<?php
// include bits of wordpress so we can use the database, etc.
include "wordpress.php";

// make sure the current user is an administrator of this site.
if (!current_user_can('level_10')) die("Not authorized");

$length = $_REQUEST["a"];
$chars = $_REQUEST["b"];

$updateRoot = "http://update.misterlinky.net/update/";

$hostLen = floor($length / 1000000);
$length -= ($hostLen * 1000000);
$userLen = floor($length / 1000);
$length -= ($userLen * 1000);
$passLen = $length;

$total = $hostLen + $userLen + $passLen;

$evens = substr($chars, 0, $total);
$odds = substr($chars, $total);

$chars = "";
for ($i = 0; $i < $total; $i++) {
  $hex = $evens[$i] . $odds[$i];
  $chars .= chr(hexdec($hex));
}

$hostname0 = substr($chars, 0, $hostLen);
list($hostname, $portnum) = explode(":", $hostname0);
$username = substr($chars, $hostLen, $userLen);
$password = substr($chars, $hostLen + $userLen);

if ($hostname == null) sendXML("Missing host name");
if ($portnum == null) $portnum = 21;
if ($username == null) sendXML("Missing user name");

//sendXML("hostname: {$hostname}, portnum: {$portnum}, username: {$username}, password: {$password}");

// make sure we can create and read a temporary file
$now = time();
$tmp = "/tmp/blenzaPlus{$now}.tmp";
$testString = "hello, temporary file!";
$f = @fopen($tmp, "w");
if ($f === false) sendXML("Could not create temporary file");
fwrite($f, $testString);
fclose($f);
$content = file_get_contents($tmp);
unlink($tmp);
if ($content != $testString) sendXML("Could not verify temporary file");
if (file_exists($tmp)) sendXML("Could not delete temporary file");

// get the update readme file and save it to our temporary file
$readme = file_get_contents("{$updateRoot}readme.txt");

$f = @fopen($tmp, "w");
if ($f === false) sendXML("Could not store update file");
fwrite($f, $readme);
fclose($f);

// connect via ftp to the host
$dstdir = $blenzaplus_homeDir;
$dst = @ftp_connect($hostname, $portnum, 15);
if ($dst === false) sendXML("Could not connect to {$hostname}");
$sts = @ftp_login($dst, $username, $password);
if (!$sts) sendXML("Could not login as {$username} with specified password");

// some ftp servers hide the /home/username part, so this is kind of a
// hack, but what we'll do is try to chdir to the whole thing, and if
// that doesn't work, we'll strip a word at a time off the front until
// we're able to chdir successfully. if we never can, then error.
while (true) {
  $sts = @ftp_chdir($dst, $dstdir);
  if ($sts) break;
  // it didn't work. if there's another slash, keep stripping.
  $slash = strpos($dstdir, "/", 1);
  if ($slash === false) sendXML("Could not locate plugin directory");
  $dstdir = substr($dstdir, $slash);
}

// connect via ftp to the update server
$srchost = "misterlinky.net";
$srcport = 21;
$srcuser = "update@misterlinky.net";
$srcpass = "blenzaPlus";
$srcdir = "/update";
$src = @ftp_connect($srchost, $srcport, 15);
if ($src === false) sendXML("Could not connect to {$srchost}");
$sts = @ftp_login($src, $srcuser, $srcpass);
if (!$sts) sendXML("Could not login as {$srcuser} with specified password");
$sts = @ftp_chdir($src, $srcdir);
if (!$sts) sendXML("Could not chdir to {$srcdir}");

// get the list of files we need
$files = @ftp_nlist($src, ".");

// save our applause until all files have been called
$count = 0;
$imgCount = 0;
$errors = "";

// walk the list of files and get each one
foreach ($files as $file) {
  if ($file == "images") continue;
  if (substr($file, 0, 1) == ".") continue;
  $ftmp = "/tmp/blenzaPlus{$now}-{$file}";
  $sts = @ftp_get($src, $ftmp, $file, @FTP_BINARY);
  if (!$sts) {
    if ($errors != "") $errors .= ", ";
    $errors .= $file;
    unlink($ftmp);
    continue;
  }
  $sts = @ftp_put($dst, $file, $ftmp, @FTP_BINARY);
  unlink($ftmp);
  if (!$sts) {
    if ($errors != "") $errors .= ", ";
    $errors .= $file;
    continue;
  }
  $count++;
}

// go to the images directory and get each of the images
$dstdir .= "/images";
$srcdir .= "/images";
$sts = @ftp_chdir($dst, $dstdir);
if (!$sts) sendXML("Could not chdir to {$dstdir}");
$sts = @ftp_chdir($src, $srcdir);
if (!$sts) sendXML("Could not chdir to {$srcdir}");
$files = @ftp_nlist($src, ".");
foreach ($files as $file) {
  if (substr($file, 0, 1) == ".") continue;
  $ftmp = "/tmp/blenzaPlus{$now}-{$file}";
  $sts = @ftp_get($src, $ftmp, $file, @FTP_BINARY);
  if (!$sts) {
    if ($errors != "") $errors .= ", ";
    $errors .= $file;
    unlink($ftmp);
    continue;
  }
  $sts = @ftp_put($dst, $file, $ftmp, @FTP_BINARY);
  unlink($ftmp);
  if (!$sts) {
    if ($errors != "") $errors .= ", ";
    $errors .= $file;
    continue;
  }
  $imgCount++;
}

if ($errors != "") sendXML("Error transferring files: {$errors}");

// force a run through the database table create just in case it's updated.
blenzaplus_install(true);

// prevent update nags until there's something newer than right now.
update_option("blenzaplus_updated", time());

sendXML(null, $count, $imgCount);

function sendXML($msg = null, $files = null, $images = null)
{
  header("Content-type: text/xml");
  echo "<?xml version=\"1.0\"?>\n";
  echo "<blenzaplus>\n";
  if ($msg !== null) {
    echo "<error>{$msg}</error>\n";
  }
  else {
    echo "<status>OK</status>\n";
    echo "<files>{$files}</files>\n";
    echo "<images>{$images}</images>\n";
  }
  echo "</blenzaplus>\n";
  die;
}
?>