<?php
// include bits of wordpress so we can use the database, etc.
include "wordpress.php";

// check for valid data
$int = blenzaplus_stripRequest('int');
if ($int === null) sendXML("Missing int", "alert");
$ext = blenzaplus_stripRequest('ext');
if ($ext === null) sendXML("Missing ext", "alert");

if (!file_exists($int)) sendXML("Disc location does not exist", "red");

$intFile = "{$int}/test.png";
$extFile = "{$ext}/test.png";

if (!@copy(WP_PLUGIN_DIR."/blenzaplus/images/nothumb.png", $intFile)) sendXML("Disc location is not writable", "red");

$intCont = @file_get_contents($intFile);
$extCont = @file_get_contents($extFile);

@unlink($intFile);

if ($intCont !== $extCont) sendXML("Disc/web locations do not match", "red");

$srcFile = WP_PLUGIN_DIR."/blenzaplus/htaccess.txt";
$intFile = "{$int}/.htaccess";
$extFile = "{$ext}/.htaccess";

if (file_exists($intFile)) {
  $srcCont = @file_get_contents($srcFile);
  $intCont = @file_get_contents($intFile);

  if ($srcCont !== $intCont) sendXML("Disc location contains incompatible .htaccess file", "red");
}
else {
  copy($srcFile, $intFile);
}

$intFile = "{$int}/test.php";
$extFile = "{$ext}/test.php";

@copy(WP_PLUGIN_DIR."/blenzaplus/test.php", $intFile);

$intCont = @file_get_contents($intFile);
$extCont = @file_get_contents($extFile);

@unlink($intFile);

if ($intCont !== $extCont) sendXML("Configured location is not secure", "red");

sendXML("Configuration is good!", "green");

function sendXML($msg = null, $color = null)
{
  header("Content-type: text/xml");
  echo "<?xml version=\"1.0\"?>\n";
  echo "<blenzaplus>\n";
  echo "<status>OK</status>\n";
  if ($msg !== null) echo "<message>{$msg}</message>\n";
  if ($color !== null) echo "<color>{$color}</color>\n";
  echo "</blenzaplus>\n";
  die;
}
?>