<?php
// include bits of wordpress so we can use the database, etc.
include "wordpress.php";

// make sure the current user is an administrator of this site.
if (!current_user_can('level_10')) die("Not authorized");

$n = $_REQUEST["n"];
$name = $_REQUEST["name"];
$value = $_REQUEST["value"];

// check for valid data
if ($n === null) sendXML("Missing post id");
if (!is_numeric($n)) sendXML("Illegal post id");
if ($name === null) sendXML("Missing name");
if ($value === null) sendXML("Missing value");

// get our post metadata
$metaStr = get_post_meta($n, "blenzaplus_meta", true);
if (strlen($metaStr) == 0) $meta = array();
else $meta = unserialize($metaStr);

$meta[$name] = $value;

// add or update the metadata for this post.
blenzaplus_updateMetadata($n, $meta);

sendXML();

function sendXML($msg = null)
{
  header("Content-type: text/xml");
  echo "<?xml version=\"1.0\"?>\n";
  echo "<blenzaplus>\n";
  if ($msg !== null) echo "<error>{$msg}</error>\n";
  else echo "<status>OK</status>\n";
  echo "</blenzaplus>\n";
  die;
}
?>