<?php
// include bits of wordpress so we can use the database, etc.
include "wordpress.php";

// make sure the current user is an administrator of this site.
if (!current_user_can('level_10')) die("Not authorized");

$n = $_REQUEST["n"];
$enabled = $_REQUEST["enabled"];
$widget = $_REQUEST["widget"];

// check for valid data
if ($n === null) sendXML("Missing post id");
if (!is_numeric($n)) sendXML("Illegal post id");
if ($enabled === null) sendXML("Missing flag");
if (!is_numeric($enabled)) sendXML("Illegal flag");
if (($enabled != 0) && ($enabled != 1)) sendXML("Illegal flag");
if ($enabled) {
  if ($widget === null) sendXML("Missing widget id");
  if ((strlen($widget) > 0) && !is_numeric($widget)) sendXML("Illegal widget id");
}

// get our post metadata
$metaStr = get_post_meta($n, "blenzaplus_meta", true);
if (strlen($metaStr) == 0) $meta = array();
else $meta = unserialize($metaStr);

$meta["enabled"] = $enabled;
$meta["widget"] = $widget;

// add or update the metadata for this post.
blenzaplus_updateMetadata($n, $meta);

sendXML();

function sendXML($msg = null)
{
  header("Content-type: text/xml");
  echo "<?xml version=\"1.0\"?>\n";
  echo "<blenzaplus>\n";
  if ($msg !== null) echo "<error>{$msg}</error>\n";
  else echo "<status>OK</status>\n";
  echo "</blenzaplus>\n";
  die;
}
?>