<script type="text/javascript">
var blenzaplus_checkKeydown = true;
var blenzaplus_inputBackground = null;
var blenzaplus_inputColor = null;

// wrapper for the real onclick function.
function blenzaplus_onclick(n)
{
  blenzaplus_checkKeydown = false;
  var ret = blenzaplus_onclick2(n);
  if (!ret) return ret;
  // in a tenth of a second, restore the key-up check
  setTimeout("blenzaplus_restoreKeydown()", 100);
  return ret;
}

function blenzaplus_restoreKeydown()
{
  blenzaplus_checkKeydown = true;
}

// called to switch from name/link to thumbnail entry
function blenzaplus_onclick1(n, form)
{
  var link;
  if (form) link = form.elements["url"];
  else link = document.getElementById("blenzaplus_link" + n);
  if (link == null) return alert("INTERNAL ERROR, Could not find the link element");
  if (link.value.substring(0, 4) == "www.") {
    link.value = "http://" + link.value;
  }
}

// called when the Participant Submit button is clicked.
function blenzaplus_onclick2(n, form)
{
  // first check for errors, make sure we have all the information
  var error = "";
  var btnId = "blenzaplus_button" + n;
  var button;
  if (form) button = form.elements["submit"];
  else button = document.getElementById(btnId);
  if (button == null) return alert("INTERNAL ERROR, Could not find the button" + " (looking for " + btnId + ")");
  var name;
  if (form) name = form.elements["author"];
  else name = document.getElementById("blenzaplus_name" + n);
  if (name == null) return alert("INTERNAL ERROR, Could not find the name element");
  blenzaplus_inputBackground = name.style.background;
  blenzaplus_inputColor = name.style.color;
  if (name.value.length == 0) {
    name.style.background = "#f00";
    name.style.color = "#fff";
    if (error.length > 0) error += "\n";
    error += "Name is required.";
  }
  var link;
  if (form) link = form.elements["url"];
  else link = document.getElementById("blenzaplus_link" + n);
  if (link == null) return alert("INTERNAL ERROR, Could not find the link element");
  var urltest = /https?:\/\/([-\w\.]+)+(:\d+)?(\/([\w/_\.]*(\?\S+)?)?)?/;
  if (link.value.substring(0, 4) == "www.") {
    link.value = "http://" + link.value;
  }
  if (link.value.length == 0) {
    link.style.background = "#f00";
    link.style.color = "#fff";
    if (error.length > 0) error += "\n";
    error += "Link is required.";
  }
  else if (!urltest.test(link.value)) {
    link.style.background = "#f00";
    link.style.color = "#fff";
    if (error.length > 0) error += "\n";
    error += "Link is not in URL format.";    
  }
  var extra = document.getElementById("blenzaplus_extra" + n);
  if (extra) {
    if (extra.value.length == 0) {
      extra.style.background = "#f00";
      extra.style.color = "#fff";
      if (error.length > 0) error += "\n";
      error += "Extra is required (see description).";
    }
  }
  if (error.length > 0) return alert(error);

  // figure out if we're doing thumbnails or not.
  var thumbs = document.getElementById("blenzaplus_thumbsRow" + n);

  if (thumbs) {
    var thumbs2 = document.getElementById("blenzaplus_thumbs2Row" + n);

    if ((thumbs.style.display == "none") && (thumbs2.style.display == "")) {
      name.disabled = true;
      link.disabled = true;
      if (extra) extra.disabled = true;

      thumbs.style.display = "";
      thumbs2.style.display = "none";
      return false;
    }
  }

  // thumbnail operation not yet set
  var op = null;
  var image = null;

  // do whatever error checking is required.
  if (thumbs) {
    var inp_op = document.getElementById("inp_op" + n);
    if (inp_op == null) return alert("Internal error, cannot find inp_op");
    op = inp_op.value;
    /*
    var secret = document.getElementById("secret" + n);
    if (secret == null) return alert("Internal error, cannot find secret");
    var id = document.getElementById("id" + n);
    if (id == null) return alert("Internal error, cannot find id");
    */
    var file = document.getElementById("imageFile" + n);
    if (file == null) return alert("Internal error, cannot find imageFile");
    var url = document.getElementById("imageURL" + n);
    if (url == null) return alert("Internal error, cannot find imageURL");
    var site = document.getElementById("imageSite" + n);
    if (site == null) return alert("Internal error, cannot find imageSite");
    var email = document.getElementById("email" + n);
    if (email == null) return alert("Internal error, cannot find email");
    <?php if ($threqd == "yes") { ?>
    if ((op == null) || (op == "")) {
      alert("Please select a thumbnail");
      return false;
    }
    <?php } ?>
    if (op == "file") {
      /*
      image = $_FILES["blenzaplus_imageFile"];
      if (image === null) wp_die("Missing image.");
      if (image["name"] == null) wp_die("Missing image.");
      if (image["type"] == null) wp_die("Missing image.");
      if (image["size"] == null) wp_die("Missing image.");
      if (!is_uploaded_file(image["tmp_name"])) wp_die("Illegal upload");
      */
    }
    else if ((op == "site") || (op == "url") || (op == "gravatar")) {
      if (op == "site") {
        image = site.value;
        if (image == null) wp_die("Please click an image.");
      }
      else if (op == "url") {
        image = url.value;
        if (image == null) wp_die("Please enter the URL of an image.");
      }
      else if (op == "gravatar") {
        image = email.value;
        if (image == null) wp_die("Please enter your e-mail address.");
      }
    }
  }

  var ipaddr = document.getElementById("blenzaplus_ipaddr");

  // prevent double-entry and other misunderstandings
  button.disabled = true;

  // animate the button -- for fun and feedback
  var ival = setInterval("blenzaplus_timer("+n+")", 400);
  button.setAttribute("interval", ival);

  var extraValue = (extra) ? extra.value : null;

  // if we're not doing thumbnails, submit it now.
  if (!thumbs) {
    blenzaplus_doEntry(n, name.value, link.value, extraValue, ipaddr.value);
  }

  // otherwise it's time to either get the thumbnails or submit everything.
  else {
    button.disabled = false;
    blenzaplus_doEntry(n, name.value, link.value, extraValue, ipaddr.value, op, image);
    return true;
  }
}

// function to get an XML request object
function blenzaplus_xmlRequest()
{
  if (window.XMLHttpRequest) return new XMLHttpRequest();
  else if (window.ActiveXObject) return new ActiveXObject("Microsoft.XMLHTTP");
  else return null;
}

// function for performing any request we need
function blenzaplus_doEntry(n, name, link, extra, ipaddr, op, image)
{
  var post = "n=" + n + "&name=" + name + "&link=" + link;
  if (extra) post += "&extra=" + extra;
  post += "&ipaddr=" + ipaddr;
  if (op) post += "&op=" + op + "&image=" + image;

  var req = null;

  try {
    // send the request to the server.
    req = blenzaplus_xmlRequest();
    var url = "<?php echo $blenzaplus_homeUrl; ?>/insertlink.php";
    req.open("POST", url, true);
    req.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
    req.onreadystatechange = function() {
      blenzaplus_return(this, n);
    };
    req.send(post);
  }
  catch (e) {
    return blenzaplus_requestError(142, e, url, post, req);
  }
}

function blenzaplus_return(req, n)
{
  if (req.readyState != 4) return;

  try {
    // handle unexpected problems
    if (req.readyState != 4) throw "State " + req.readyState;
    if (req.status != 200) throw "Status " + req.status;
    if (req.responseXML == null) throw "No XML returned";

    // handle expected return data
    var data = req.responseXML.getElementsByTagName("blenzaplus");
    if ((data == null) || (data.length != 1)) throw "No data returned";

    // parse the data that did come back.
    var errorRet = null;
    var errorTag = data[0].getElementsByTagName("error");
    if (errorTag.length > 0) errorRet = errorTag[0].firstChild.data;
    var statusRet = null;
    var statusTag = data[0].getElementsByTagName("status");
    if (statusTag.length > 0) statusRet = statusTag[0].firstChild.data;
    var secretRet = null;
    var secretTag = data[0].getElementsByTagName("secret");
    if (secretTag.length > 0) secretRet = secretTag[0].firstChild.data;
    var idRet = null;
    var idTag = data[0].getElementsByTagName("id");
    if (idTag.length > 0) idRet = idTag[0].firstChild.data;

    // if there was a site issue, note it and move on.
    if (statusRet.substr(0, 1) == "%") {
      var stats = statusRet.split("/", 2);
      var msg;
      if (stats[0] == "%THUMBREQ") msg = "Please select a thumbnail";
      else throw "Internal error";
      alert(msg);
      blenzaplus_finish(n, true);
      return false;
    }
    
    // make sure the operation succeeded
    if (errorRet) throw errorRet;
    if (statusRet != "OK") throw "Internal error";
    if (secretRet == "") secretRet = null;
    if (statusRet != "OK") throw "Internal error";
    if (idRet == "") idRet = null;

    // success!
    blenzaplus_finish(n, false, secretRet, idRet);
  }
  catch (e) {
    blenzaplus_finish(n, true);
    return blenzaplus_requestError(186, e, null, data, req);
  }
}

function blenzaplus_timer(n)
{
  var button = document.getElementById("blenzaplus_button" + n);
  if (button == null) return;
  var text = button.value;
  var pos = text.indexOf(".");
  if (pos < 0) {
    button.value = text + ".";
    return;
  }
  else if (pos == 0) {
    button.value = text.substring(1) + ".";
    return;
  }
  button.value = text.substring(0, pos-1) + "." + text.substring(pos-1, pos) + text.substring(pos+1);
}

function blenzaplus_finish(n, error, secret, id)
{
  var button = document.getElementById("blenzaplus_button" + n);
  if (button == null) return;
  var ival = button.getAttribute("interval");
  clearInterval(ival);

  if (error) {
    button.disabled = false;
    button.value = "Submit";
    var name = document.getElementById("blenzaplus_name" + n);
    if (name) name.disabled = false;
    var link = document.getElementById("blenzaplus_link" + n);
    if (link) link.disabled = false;
    var extra = document.getElementById("blenzaplus_extra" + n);
    if (extra) extra.disabled = false;
  }
  else {
    button.value = "Submitted!";
  }
}

function blenzaplus_infocus(ele)
{
  if (!blenzaplus_inputBackground) ele.style.background = "#fff";
  else ele.style.background = blenzaplus_inputBackground;
  if (!blenzaplus_inputColor) ele.style.color = "#000";
  else ele.style.color = blenzaplus_inputColor;
}

function blenzaplus_inkeydown(n, evt, ele)
{
  // if we're in the middle of the form validation, there might be
  // some alerting going on, and if the user dismisses the alert with
  // a return, we don't want to capture that.
  if (!blenzaplus_checkKeydown) return;

  if (evt.which == 13) blenzaplus_onclick(n);
}

function blenzaplus_toggleDescription(ele)
{
  var tags = ele.getElementsByTagName("span");
  for (var i = 0; i < tags.length; i++) {
    if (tags[i].style.display == "none") tags[i].style.display = "inline";
    else tags[i].style.display = "none";
  }
}

function blenzaplus_selected(n)
{
  if (n == null) return;

  var sel = document.getElementById("blenzaplus_selector" + n);
  var val = sel.options[sel.selectedIndex].value;

  if (val == "edit") {
    var win = window.open("<?php echo WP_ADMIN_URL; ?>/post.php?action=edit&post=" + n + "#blenzaplus");
    return;
  }

  var enabled;
  var widget;
  if (val == "") {
    enabled = 0;
    widget = "";
  }
  else if (val == "plain") {
    enabled = 1;
    widget = "";
  }
  else {
    enabled = 1;
    widget = val;
  }

  var post = "n=" + n + "&enabled=" + enabled + "&widget=" + widget;
  var req = null;

  try {
    // send the request to the server.
    req = blenzaplus_xmlRequest();
    var url = "<?php echo $blenzaplus_homeUrl; ?>/select.php";
    req.open("POST", url, false);
    req.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
    req.send(post);

    // handle unexpected problems
    if (req.readyState != 4) throw "State " + req.readyState;
    if (req.status != 200) throw "Status " + req.status;
    if (req.responseXML == null) throw "No XML returned";

    // handle expected return data
    var data = req.responseXML.getElementsByTagName("blenzaplus");
    if ((data == null) || (data.length != 1)) throw "No data returned";

    // parse the data that did come back.
    var errorRet = null;
    var errorTag = data[0].getElementsByTagName("error");
    if (errorTag.length > 0) errorRet = errorTag[0].firstChild.data;
    var statusRet = null;
    var statusTag = data[0].getElementsByTagName("status");
    if (statusTag.length > 0) statusRet = statusTag[0].firstChild.data;

    // make sure the operation succeeded
    if (errorRet) throw errorRet;
    if (statusRet != "OK") throw "Internal error";

    // success!
    if (confirm("The widget has been " + (enabled?"enabled":"disabled") + ". Do you wish to reload this page?")) blenzaplus_reload();
  }
  catch (e) {
    return blenzaplus_requestError(335, e, url, post, req);
  }
}

function blenzaplus_setMetadata(n, name, value)
{
  if (n == null) return false;

  var post = "n=" + n + "&name=" + escape(name) + "&value=" + escape(value);

  var req = null;

  try {
    // send the request to the server.
    req = blenzaplus_xmlRequest();
    var url = "<?php echo $blenzaplus_homeUrl; ?>/setmeta.php";
    req.open("POST", url, false);
    req.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
    req.send(post);

    // handle unexpected problems
    if (req.readyState != 4) throw "State " + req.readyState;
    if (req.status != 200) throw "Status " + req.status;
    if (req.responseXML == null) throw "No XML returned";

    // handle expected return data
    var data = req.responseXML.getElementsByTagName("blenzaplus");
    if ((data == null) || (data.length != 1)) throw "No data returned";

    // parse the data that did come back.
    var errorRet = null;
    var errorTag = data[0].getElementsByTagName("error");
    if (errorTag.length > 0) errorRet = errorTag[0].firstChild.data;
    var statusRet = null;
    var statusTag = data[0].getElementsByTagName("status");
    if (statusTag.length > 0) statusRet = statusTag[0].firstChild.data;

    // make sure the operation succeeded
    if (errorRet) throw errorRet;
    if (statusRet != "OK") throw "Internal error";

    // success!
    return true;
  }
  catch (e) {
    return blenzaplus_requestError(380, e, url, post, req, false);
  }
}

function blenzaplus_convertExternalBegin(n)
{
  window.location.href="<?php echo WP_ADMIN_URL; ?>/post.php?action=edit&post=" + n + "&blenzaplus_external=1#blenzaplus";
}

function blenzaplus_convertExternalPhase(n, phase)
{
  var btn = document.getElementById("blenzaplus_convertBtnCancel");
  if ((phase == 0) && (btn.value == "Done")) {
    window.location.href="<?php echo WP_ADMIN_URL; ?>/post.php?action=edit&post=" + n + "&blenzaplus_refresh=" + new Date().getTime() + "#blenzaplus";
    return;
  }

  var div = document.getElementById("blenzaplus_convertExternalLink");
  if (phase == 0) div.style.display = "block";
  else div.style.display = "none";

  var div = document.getElementById("blenzaplus_convertExternalWrap");
  div.setAttribute("currentPhase", phase);
  if (phase == 0) div.style.display = "none";
  else div.style.display = "block";

  var div = document.getElementById("blenzaplus_convertExternalPhase");
  div.innerHTML = phase;

  var divs = document.getElementsByName("blenzaplus_convertExternal");
  for (var i = 0; i < divs.length; i++) {
    var div = divs[i];
    if (div.getAttribute("phase") == phase) div.style.display = "block";
    else div.style.display = "none";
  }

  // enable/disable buttons
  var btn = document.getElementById("blenzaplus_convertBtnNext");
  btn.disabled = (phase >= 5);
  var btn = document.getElementById("blenzaplus_convertBtnPrev");
  btn.disabled = ((phase <= 1) || (phase == 5));
}

function blenzaplus_ignoreExternal(n)
{
  if (!blenzaplus_setMetadata(n, "ignoreExternal", 1)) return;

  var div = document.getElementById("blenzaplus_ignoreExternal" + n);
  if (div != null) div.style.display = "none";

  alert("External widget for this post will be ignored.  You may access import/conversion functions at the linky widget section of the post editor.");
}

function blenzaplus_radioClick(name, value)
{
  var elems = document.getElementsByName("blenzaplus_" + name);
  if (elems.length == 0) return;
  if (elems[0].type != "radio") return;
  for (var i = 0; i < elems.length; i++) {
      if (elems[i].value == value) elems[i].checked = true;
      else elems[i].checked = false;
  }
}

function blenzaplus_getValue(name)
{
  var elems = document.getElementsByName("blenzaplus_" + name);
  if (elems.length == 0) return null;
  var elem = elems[0];
  if (elem.tagName == "SELECT") return elem.options[elem.selectedIndex].value;
  if (elem.tagName != "INPUT") return elem.tagName + " is not INPUT";
  if (elem.type != "radio") return elem.type + " is not RADIO";
  for (var i = 0; i < elems.length; i++) {
    if (elems[i].checked) return elems[i].value;
  }
}

function blenzaplus_showExtra(n, str)
{
  var div = document.getElementById("blenzaplus_linkExtra" + n);
  if (div == null) alert(str);
  else if (div.style.display == "none") div.style.display = "block";
  else div.style.display = "none";
}

/*
function blenzaplus_showMenu(n, disp)
{
  var div = document.getElementById("blenzaplus_widgetMenu" + n);
  if (div == null) return alert("menu not found");
  if (disp == null) {
    if (div.style.display == "none") disp = "block"; else disp = "none";
  }
  div.style.display = disp;
}
*/

function blenzaplus_showExtras(n, c)
{
  var disp = null;
  for (var i = 1; i <= c; i++) {
    var name = "blenzaplus_linkExtra" + n + "_" + i + "a";
    var div = document.getElementById(name);
    if (div == null) return alert("div not found in showExtras, " + name);
    if (i == 1) {
      if (div.style.display == "none") disp = "inline"; else disp = "none";
    }
    div.style.display = disp;
  }
}

function blenzaplus_showEdits(n, c)
{
  var disp = null;
  for (var i = 1; i <= c; i++) {
    var name = "blenzaplus_linkEdits" + n + "_" + i;
    var div = document.getElementById(name);
    if (div == null) return alert("div not found in showEdits, " + name);
    if (i == 1) {
      if (div.style.display == "none") disp = "inline"; else disp = "none";
    }
    div.style.display = disp;
  }
  /*
    var name = "blenzaplus_linkEditsSubmitTop" + n;
    var div = document.getElementById(name);
    if (div == null) return alert("div not found in showEdits, " + name);
    if (i == 1) {
    if (div.style.display == "none") disp = "inline"; else disp = "none";
    }
    div.style.display = disp;
  */
  var name = "blenzaplus_linkEditsSubmitBot" + n;
  var div = document.getElementById(name);
  if (div == null) return alert("div not found in showEdits, " + name);
  if (i == 1) {
    if (div.style.display == "none") disp = "inline"; else disp = "none";
  }
  div.style.display = disp;
}

function blenzaplus_showSpams(n, c)
{
  var disp = null;
  for (var i = 1; i <= c; i++) {
    var name = "blenzaplus_linkSpams" + n + "_" + i;
    var div = document.getElementById(name);
    if (div == null) continue; //return alert("div not found in showSpams, " + name);
    if (i == 1) {
      if (div.style.display == "none") disp = "inline"; else disp = "none";
    }
    div.style.display = disp;
  }
  if (disp == "none") return;
  //alert("Please click REPORT next to the inappropriate link.");
}

function blenzaplus_deleteLink(n, m, id)
{
  if (!confirm("Are you sure you wish to delete link #"+m+"?")) return;

  var post = "n=" + n + "&id=" + id;

  var req = null;

  try {
    // send the request to the server.
    req = blenzaplus_xmlRequest();
    var url = "<?php echo $blenzaplus_homeUrl; ?>/deletelink.php";
    req.open("POST", url, false);
    req.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
    req.send(post);

    // handle unexpected problems
    if (req.readyState != 4) throw "State " + req.readyState;
    if (req.status != 200) throw "Status " + req.status;
    if (req.responseXML == null) throw "No XML returned";

    // handle expected return data
    var data = req.responseXML.getElementsByTagName("blenzaplus");
    if ((data == null) || (data.length != 1)) throw "No data returned";

    // parse the data that did come back.
    var errorRet = null;
    var errorTag = data[0].getElementsByTagName("error");
    if (errorTag.length > 0) errorRet = errorTag[0].firstChild.data;
    var statusRet = null;
    var statusTag = data[0].getElementsByTagName("status");
    if (statusTag.length > 0) statusRet = statusTag[0].firstChild.data;

    // make sure the operation succeeded
    if (errorRet) throw errorRet;
    if (statusRet != "OK") throw "Internal error";

    // success!
    if (confirm("The link has been deleted. Do you wish to reload this page?")) blenzaplus_reload();
  }
  catch (e) {
    return blenzaplus_requestError(578, e, url, post, req);
  }
}

function blenzaplus_updateLinks(form, action)
{
  var n = form.elements["postid"].value;
  var ids = form.elements["ids"];
  var idList = "";
  var c = 0;
  for (var i = 0; i < ids.length; i++) {
    if (!ids[i].checked) continue;
    if (c > 0) idList += ",";
    idList += ids[i].value;
    c++;
  }
  if (c == 0) {
    alert("No links were selected.");
    return;
  }
  var links;
  if (c == 1) links = "one selected link";
  else links = c + " selected links";
  if (!confirm("Are you sure you wish to " + action + " the " + links + "?")) return;

  var post = "n=" + n + "&ids=" + idList;

  var req = null;

  try {
    // send the request to the server.
    req = blenzaplus_xmlRequest();
    var url = "<?php echo $blenzaplus_homeUrl; ?>/" + action + "links.php";
    req.open("POST", url, false);
    req.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
    req.send(post);

    // handle unexpected problems
    if (req.readyState != 4) throw "State " + req.readyState;
    if (req.status != 200) throw "Status " + req.status;
    if (req.responseXML == null) throw "No XML returned";

    // handle expected return data
    var data = req.responseXML.getElementsByTagName("blenzaplus");
    if ((data == null) || (data.length != 1)) throw "No data returned";

    // parse the data that did come back.
    var errorRet = null;
    var errorTag = data[0].getElementsByTagName("error");
    if (errorTag.length > 0) errorRet = errorTag[0].firstChild.data;
    var statusRet = null;
    var statusTag = data[0].getElementsByTagName("status");
    if (statusTag.length > 0) statusRet = statusTag[0].firstChild.data;

    // make sure the operation succeeded
    if (errorRet) throw errorRet;
    if (statusRet != "OK") throw "Internal error";

    // success!
    if (confirm("The " + links + " have been " + action + "d. Do you wish to reload this page?")) blenzaplus_reload();
  }
  catch (e) {
    return blenzaplus_requestError(640, e, url, post, req);
  }
}

function blenzaplus_deleteAllLinks(n)
{
  if (!confirm("Are you sure you wish to delete all links?")) return;

  var post = "n=" + n;

  var req = null;

  try {
    // send the request to the server.
    req = blenzaplus_xmlRequest();
    var url = "<?php echo $blenzaplus_homeUrl; ?>/deletealllinks.php";
    req.open("POST", url, false);
    req.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
    req.send(post);

    // handle unexpected problems
    if (req.readyState != 4) throw "State " + req.readyState;
    if (req.status != 200) throw "Status " + req.status;
    if (req.responseXML == null) throw "No XML returned";

    // handle expected return data
    var data = req.responseXML.getElementsByTagName("blenzaplus");
    if ((data == null) || (data.length != 1)) throw "No data returned";

    // parse the data that did come back.
    var errorRet = null;
    var errorTag = data[0].getElementsByTagName("error");
    if (errorTag.length > 0) errorRet = errorTag[0].firstChild.data;
    var statusRet = null;
    var statusTag = data[0].getElementsByTagName("status");
    if (statusTag.length > 0) statusRet = statusTag[0].firstChild.data;

    // make sure the operation succeeded
    if (errorRet) throw errorRet;
    if (statusRet != "OK") throw "Internal error";

    // success!
    if (confirm("All links have been deleted. Do you wish to reload this page?")) blenzaplus_reload();
  }
  catch (e) {
    return blenzaplus_requestError(685, e, url, post, req);
  }
}

function blenzaplus_checkTrouble(form)
{
  var ids = form.elements["ids"];
  for (var i = 0; i < ids.length; i++) {
    var t = ids[i].getAttribute("trouble");
    if (t == 1) ids[i].checked = true;
  }
}

function blenzaplus_uncheckAll(form)
{
  var ids = form.elements["ids"];
  for (var i = 0; i < ids.length; i++) {
    ids[i].checked = false;
  }
}

var blenzaplus_editing = null;

function blenzaplus_editLink(n, m)
{
  var name = "blenzaplus_linkEdit" + n + "_" + m;
  var div = document.getElementById(name);
  if (div == null) return alert("INTERNAL ERROR, div not found in editLink, " + name);
  div.style.display = "block";
  if (blenzaplus_editing != null) blenzaplus_editing.style.display = "none";
  blenzaplus_editing = div;
}

function blenzaplus_spamLink(n, m, id)
{
  var name = "blenzaplus_link" + n + "_" + m;
  var anc = document.getElementById(name);
  if (!confirm("Are you sure you wish to report link #"+m+"?\n\nName: " + anc.text + "\nLink: " + anc.href)) return;

  var post = "n=" + n + "&id=" + id;

  var req = null;

  try {
    // send the request to the server.
    req = blenzaplus_xmlRequest();
    var url = "<?php echo $blenzaplus_homeUrl; ?>/spamlink.php";
    req.open("POST", url, false);
    req.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
    req.send(post);

    // handle unexpected problems
    if (req.readyState != 4) throw "State " + req.readyState;
    if (req.status != 200) throw "Status " + req.status;
    if (req.responseXML == null) throw "No XML returned";

    // handle expected return data
    var data = req.responseXML.getElementsByTagName("blenzaplus");
    if ((data == null) || (data.length != 1)) throw "No data returned";

    // parse the data that did come back.
    var errorRet = null;
    var errorTag = data[0].getElementsByTagName("error");
    if (errorTag.length > 0) errorRet = errorTag[0].firstChild.data;
    var statusRet = null;
    var statusTag = data[0].getElementsByTagName("status");
    if (statusTag.length > 0) statusRet = statusTag[0].firstChild.data;

    // make sure the operation succeeded
    if (errorRet) throw errorRet;
    if (statusRet != "OK") throw "Internal error";

    // success!
    alert("Thank you. The link has been reported.");
  }
  catch (e) {
    return blenzaplus_requestError(761, e, url, post, req);
  }
}

function blenzaplus_approveLink(n, m, id)
{
  var name = "blenzaplus_link" + n + "_" + m;
  var anc = document.getElementById(name);
  if (!confirm("Are you sure you wish to approve link #"+m+"?\n\nName: " + anc.text + "\nLink: " + anc.href)) return;

  var post = "n=" + n + "&id=" + id;

  var req = null;

  try {
    // send the request to the server.
    req = blenzaplus_xmlRequest();
    var url = "<?php echo $blenzaplus_homeUrl; ?>/approvelink.php";
    req.open("POST", url, false);
    req.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
    req.send(post);

    // handle unexpected problems
    if (req.readyState != 4) throw "State " + req.readyState;
    if (req.status != 200) throw "Status " + req.status;
    if (req.responseXML == null) throw "No XML returned";

    // handle expected return data
    var data = req.responseXML.getElementsByTagName("blenzaplus");
    if ((data == null) || (data.length != 1)) throw "No data returned";

    // parse the data that did come back.
    var errorRet = null;
    var errorTag = data[0].getElementsByTagName("error");
    if (errorTag.length > 0) errorRet = errorTag[0].firstChild.data;
    var statusRet = null;
    var statusTag = data[0].getElementsByTagName("status");
    if (statusTag.length > 0) statusRet = statusTag[0].firstChild.data;

    // make sure the operation succeeded
    if (errorRet) throw errorRet;
    if (statusRet != "OK") throw "Internal error";

    // success!
    if (confirm("The link has been approved. Do you wish to reload this page?")) blenzaplus_reload();
  }
  catch (e) {
    return blenzaplus_requestError(808, e, url, post, req);
  }
}

function blenzaplus_approveThumbnail(n, m, id)
{
  var name = "blenzaplus_link" + n + "_" + m;
  var anc = document.getElementById(name);
  if (!confirm("Are you sure you wish to approve thumbnail #"+m+"?\n\nName: " + anc.text + "\nLink: " + anc.href)) return;

  var post = "n=" + n + "&id=" + id;

  var req = null;

  try {
    // send the request to the server.
    req = blenzaplus_xmlRequest();
    var url = "<?php echo $blenzaplus_homeUrl; ?>/approvethumb.php";
    req.open("POST", url, false);
    req.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
    req.send(post);

    // handle unexpected problems
    if (req.readyState != 4) throw "State " + req.readyState;
    if (req.status != 200) throw "Status " + req.status;
    if (req.responseXML == null) throw "No XML returned";

    // handle expected return data
    var data = req.responseXML.getElementsByTagName("blenzaplus");
    if ((data == null) || (data.length != 1)) throw "No data returned";

    // parse the data that did come back.
    var errorRet = null;
    var errorTag = data[0].getElementsByTagName("error");
    if (errorTag.length > 0) errorRet = errorTag[0].firstChild.data;
    var statusRet = null;
    var statusTag = data[0].getElementsByTagName("status");
    if (statusTag.length > 0) statusRet = statusTag[0].firstChild.data;

    // make sure the operation succeeded
    if (errorRet) throw errorRet;
    if (statusRet != "OK") throw "Internal error";

    // success!
    if (confirm("The thumbnail has been approved. Do you wish to reload this page?")) blenzaplus_reload();
  }
  catch (e) {
    return blenzaplus_requestError(808, e, url, post, req);
  }
}

function blenzaplus_reload()
{
  var url = window.location.href;
  var ref = url.indexOf("blenzaplus_refresh=");
  if (ref > 0) url = url.substr(0, ref-1);
  var hash = url.indexOf("#");
  var goto = null;
  if (hash >= 0) {
    goto = url.substr(hash);
    url = url.substr(0, hash);
  }
  if (url.indexOf("?") >= 0) url += "&";
  else url += "?";
  url += "blenzaplus_refresh=" + new Date().getTime();
  if (goto != null) url += goto;
  window.location.href = url;
}

function blenzaplus_updateCancel(n, m)
{
  var nm = "blenzaplus_linkEdit" + n + "_" + m;
  var div = document.getElementById(nm);
  if (div == null) return alert("INTERNAL ERROR, div not found in updateLink, " + nm);
  div.style.display = "none";
  blenzaplus_editing = null;
}

function blenzaplus_updateLink(n, m, id)
{
  var nm = "blenzaplus_linkEdit" + n + "_" + m;
  var div = document.getElementById(nm);
  if (div == null) return alert("INTERNAL ERROR, div not found in updateLink, " + nm);
  div.style.display = "none";
  blenzaplus_editing = null;

  var nm = "blenzaplus_editName" + n + "_" + m;
  var ele = document.getElementById(nm);
  if (ele == null) return alert("INTERNAL ERROR, Name element not found in updateLink, " + nm);
  var name = ele.value;

  var nm = "blenzaplus_editLink" + n + "_" + m;
  var ele = document.getElementById(nm);
  if (ele == null) return alert("INTERNAL ERROR, Link element not found in updateLink, " + nm);
  var link = ele.value;

  var nm = "blenzaplus_editExtra" + n + "_" + m;
  var ele = document.getElementById(nm);
  if (ele == null) return alert("INTERNAL ERROR, Extra element not found in updateLink, " + nm);
  var extra = ele.value;

  var post = "n=" + n + "&id=" + id + "&name=" + name + "&link=" + link;
  if (extra) post += "&extra=" + extra;

  var req = null;

  try {
    // send the request to the server.
    req = blenzaplus_xmlRequest();
    var url = "<?php echo $blenzaplus_homeUrl; ?>/updatelink.php";
    req.open("POST", url, false);
    req.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
    req.send(post);

    // handle unexpected problems
    if (req.readyState != 4) throw "State " + req.readyState;
    if (req.status != 200) throw "Status " + req.status;
    if (req.responseXML == null) throw "No XML returned";

    // handle expected return data
    var data = req.responseXML.getElementsByTagName("blenzaplus");
    if ((data == null) || (data.length != 1)) throw "No data returned";

    // parse the data that did come back.
    var errorRet = null;
    var errorTag = data[0].getElementsByTagName("error");
    if (errorTag.length > 0) errorRet = errorTag[0].firstChild.data;
    var statusRet = null;
    var statusTag = data[0].getElementsByTagName("status");
    if (statusTag.length > 0) statusRet = statusTag[0].firstChild.data;

    // make sure the operation succeeded
    if (errorRet) throw errorRet;
    if (statusRet != "OK") throw "Internal error";

    // success!
    if (confirm("The link has been updated. Do you wish to reload this page?")) blenzaplus_reload();
  }
  catch (e) {
    return blenzaplus_requestError(947, e, url, post, req);
  }
}

function blenzaplus_prepareExternalWidget(n)
{
  var post = "n=" + n;

  var req = null;

  try {
    // send the request to the server.
    req = blenzaplus_xmlRequest();
    var url = "<?php echo $blenzaplus_homeUrl; ?>/prepareexternal.php";
    req.open("POST", url, false);
    req.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
    req.send(post);

    // handle unexpected problems
    if (req.readyState != 4) throw "State " + req.readyState;
    if (req.status != 200) throw "Status " + req.status;
    if (req.responseXML == null) throw "No XML returned";

    // handle expected return data
    var data = req.responseXML.getElementsByTagName("blenzaplus");
    if ((data == null) || (data.length != 1)) throw "No data returned";
    // parse the data that did come back.
    var errorRet = null;
    var errorTag = data[0].getElementsByTagName("error");
    if (errorTag.length > 0) errorRet = errorTag[0].firstChild.data;
    var statusRet = null;
    var statusTag = data[0].getElementsByTagName("status");
    if (statusTag.length > 0) statusRet = statusTag[0].firstChild.data;
    var serverRet = null;
    var serverTag = data[0].getElementsByTagName("server");
    if (serverTag.length > 0) serverRet = serverTag[0].firstChild.data;
    var paramsRet = null;
    var paramsTag = data[0].getElementsByTagName("params");
    if (paramsTag.length > 0) paramsRet = paramsTag[0].firstChild.data;
    var displayRet = null;
    var displayTag = data[0].getElementsByTagName("display");
    if (displayTag.length > 0) displayRet = displayTag[0].firstChild.data;

    // make sure the operation succeeded
    if (errorRet) throw errorRet;
    if (statusRet != "OK") throw "Internal error";

    // success!
    return new Array(serverRet, paramsRet, displayRet);
  }
  catch (e) {
    return blenzaplus_requestError(998, e, url, post, req);
  }
}

function blenzaplus_convertExternalWidget(n)
{
  // function to get the text from an xml node.
  // Firefox has a 4K limit for XML nodes, but textContent retrieves the
  // whole thing; IE doesn't support textContent, so do it both ways.
  // see http://www.coderholic.com/firefox-4k-xml-node-limit/
  function getNodeText(xmlNode)
  {
    if(!xmlNode) return '';
    if(typeof(xmlNode.textContent) != "undefined") return xmlNode.textContent;
    return xmlNode.firstChild.nodeValue;
  }

  var post = "n=" + n;

  var req = null;

  try {
    // send the request to the server.
    req = blenzaplus_xmlRequest();
    var url = "<?php echo $blenzaplus_homeUrl; ?>/convertexternal.php";
    req.open("POST", url, false);
    req.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
    req.send(post);

    // handle unexpected problems
    if (req.readyState != 4) throw "State " + req.readyState;
    if (req.status != 200) throw "Status " + req.status;
    if (req.responseXML == null) throw "No XML returned";

    // handle expected return data
    var data = req.responseXML.getElementsByTagName("blenzaplus");
    if ((data == null) || (data.length != 1)) throw "No data returned";
    // parse the data that did come back.
    var errorRet = null;
    var errorTag = data[0].getElementsByTagName("error");
    if (errorTag.length > 0) errorRet = errorTag[0].firstChild.data;
    var statusRet = null;
    var statusTag = data[0].getElementsByTagName("status");
    if (statusTag.length > 0) statusRet = statusTag[0].firstChild.data;
    var contentRet = null;
    var contentTag = data[0].getElementsByTagName("content");
    if (contentTag.length > 0) contentRet = getNodeText(contentTag[0]);

    // make sure the operation succeeded
    if (errorRet) throw errorRet;
    if (statusRet != "OK") throw "Internal error";

    // success!
    return contentRet;
  }
  catch (e) {
    return blenzaplus_requestError(1054, e, url, post, req);
  }
}

function blenzaplus_finishExternalWidget(n)
{
  var post = "n=" + n;

  var req = null;

  try {
    // send the request to the server.
    req = blenzaplus_xmlRequest();
    var url = "<?php echo $blenzaplus_homeUrl; ?>/finishexternal.php";
    req.open("POST", url, false);
    req.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
    req.send(post);

    // handle unexpected problems
    if (req.readyState != 4) throw "State " + req.readyState;
    if (req.status != 200) throw "Status " + req.status;
    if (req.responseXML == null) throw "No XML returned";

    // handle expected return data
    var data = req.responseXML.getElementsByTagName("blenzaplus");
    if ((data == null) || (data.length != 1)) throw "No data returned";
    // parse the data that did come back.
    var errorRet = null;
    var errorTag = data[0].getElementsByTagName("error");
    if (errorTag.length > 0) errorRet = errorTag[0].firstChild.data;
    var statusRet = null;
    var statusTag = data[0].getElementsByTagName("status");
    if (statusTag.length > 0) statusRet = statusTag[0].firstChild.data;

    // make sure the operation succeeded
    if (errorRet) throw errorRet;
    if (statusRet != "OK") throw "Internal error";

    // success!
    return true;
  }
  catch (e) {
    return blenzaplus_requestError(1096, e, url, post, req);
  }
}

function blenzaplus_toggleHint(name)
{
  var back = document.getElementById("blenzaplus_" + name + "Back");
  var front = document.getElementById("blenzaplus_" + name + "Front");
  if ((back == null) || (front == null)) return;
  if (back.style.display == "none") disp = "inline"; else disp = "none";
  back.style.display = disp;
  front.style.display = disp;
}

function blenzaplus_getSiteThumbs(n, url)
{
  var post = "n=" + n + "&url=" + url;

  var req = null;

  try {
    // send the request to the server.
    req = blenzaplus_xmlRequest();
    var url = "<?php echo $blenzaplus_homeUrl; ?>/getsitethumbs.php";
    req.open("POST", url, false);
    req.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
    req.send(post);

    // handle unexpected problems
    if (req.readyState != 4) throw "State " + req.readyState;
    if (req.status != 200) throw "Status " + req.status;
    if (req.responseXML == null) throw "No XML returned";

    // handle expected return data
    var data = req.responseXML.getElementsByTagName("blenzaplus");
    if ((data == null) || (data.length != 1)) throw "No data returned";

    // parse the data that did come back.
    var errorRet = null;
    var errorTag = data[0].getElementsByTagName("error");
    if (errorTag.length > 0) errorRet = errorTag[0].firstChild.data;
    var statusRet = null;
    var statusTag = data[0].getElementsByTagName("status");
    if (statusTag.length > 0) statusRet = statusTag[0].firstChild.data;

    var images = data[0].getElementsByTagName("image");

    // make sure the operation succeeded
    if (errorRet) throw errorRet;

    // if there was a site issue, note it and move on.
    if (statusRet.substr(0, 1) == "%") {
      var msg;
      if (statusRet == "%NOCONTENT") msg = "Site content could not be retrieved";
      else if (statusRet == "%NOIMAGES") msg = "No images were found on your site";
      else throw "Internal error";
      alert(msg);
      return false;
    }
    
    // otherwise deal with the unexpected (not)
    else if (statusRet != "OK") throw "Internal error";

    // success!
    var name = "pickContainer" + n;
    var div = document.getElementById(name);
    var imageTags = "";
    for (var i = 0; i < images.length; i++) {
      imageTags += "<img onclick=\"pickpic<?php echo blenzaplus_postId(); ?>(this)\" style=\"display:inline;border:4px solid #777\" height=\"75\" src=\"";
      imageTags += images[i].firstChild.data;
      imageTags += "\">";
    }
    div.innerHTML = imageTags;

    return true;
  }
  catch (e) {
    blenzaplus_requestError(1159, e, url, post, req);
    return false;
  }
}

function blenzaplus_doThumbs(n, op, secret, id, file, url, site, email)
{
  var post = "n=" + n + "&op=" + op + "&secret=" + secret
    + "&id=" + id + "&imageFile=" + file + "&imageURL=" + url
    + "&imageSite=" + site + "&emailAddress=" + email;

  var req = null;

  try {
    // send the request to the server.
    req = blenzaplus_xmlRequest();
    var url = "<?php echo $blenzaplus_homeUrl; ?>/insertthumb.php";
    req.open("POST", url, false);
    req.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
    req.send(post);

    // handle unexpected problems
    if (req.readyState != 4) throw "State " + req.readyState;
    if (req.status != 200) throw "Status " + req.status;
    if (req.responseXML == null) throw "No XML returned";

    // handle expected return data
    var data = req.responseXML.getElementsByTagName("blenzaplus");
    if ((data == null) || (data.length != 1)) throw "No data returned";

    // parse the data that did come back.
    var errorRet = null;
    var errorTag = data[0].getElementsByTagName("error");
    if (errorTag.length > 0) errorRet = errorTag[0].firstChild.data;
    var statusRet = null;
    var statusTag = data[0].getElementsByTagName("status");
    if (statusTag.length > 0) statusRet = statusTag[0].firstChild.data;

    var images = data[0].getElementsByTagName("image");

    // make sure the operation succeeded
    if (errorRet) throw errorRet;

    // if there was a site issue, note it and move on.
    if (statusRet.substr(0, 1) == "%") {
      var stats = statusRet.split("/", 2);
      var msg;
      if (stats[0] == "%FILETYPE") msg = "Unknown file extension: " + stats[1];
      else throw "Internal error";
      alert(msg);
      return false;
    }
    
    // otherwise deal with the unexpected (not)
    else if (statusRet != "OK") throw "Internal error";

    // success!
    var button = document.getElementById("blenzaplus_button" + n);
    if (button == null) return;
    var ival = button.getAttribute("interval");
    clearInterval(ival);

    var thumbs = document.getElementById("blenzaplus_thumbsRow" + n);
    var thumbs2 = document.getElementById("blenzaplus_thumbs2Row" + n);
    if (thumbs == null) return;

    button.value = "Thumbnail Submitted";
    thumbs.style.display = "none";

    if (confirm("The thumbnail has been submitted. Do you wish to reload this page?")) blenzaplus_reload();
  }
  catch (e) {
    return blenzaplus_requestError(1217, e, url, post, req);
  }
}

function blenzaplus_requestError(rn, err, url, post, req, ret) {
  var msg = "An error occurred processing request #" + rn + ".";
  if (err) msg += "\n\nError: " + err;
  if (url) msg += "\n\nURL: " + url;
  if (post) msg += "\n\nData: " + post;
  if (req.responseText) msg += "\n\n" + req.responseText;
  msg += "\n\nIf you would be so kind as to email this error text (or screen capture) to mister.linky@gmail.com it will be addressed as soon as possible.";
  alert(msg);
  if (ret != null) return ret;
  return null;
}

</script>
