<?php
// include bits of wordpress so we can use the database, etc.
include "wordpress.php";

// make sure the current user is an administrator of this site.
if (!current_user_can('level_10')) die("Not authorized");

$n = $_REQUEST["n"];

// get the post and the external widget info from it
$post = get_post($n);
$ext = blenzaplus_externalWidgetCheck($post->post_content);
if (!$ext) sendXML("External widget not found in post");

$arr = blenzaplus_externalWidgetLink($post->post_content);
if ($arr == null) sendXML("External widget code not available");

$extCode = blenzaplus_externalWidgetCode($post->post_content);

// get our post metadata
$metaStr = get_post_meta($n, "blenzaplus_meta", true);
if (strlen($metaStr) == 0) $meta = array();
else $meta = unserialize($metaStr);

// save the link for later in the metadata for this post
$meta["externalCode"] = $extCode[0];
$meta["extServer"] = $arr["server"];
$meta["extLink"] = $arr["root"] . $arr["params"];
$meta["dispLink"] = $arr["dispRoot"] . $arr["params"];

// add or update the metadata for this post.
blenzaplus_updateMetadata($n, $meta);

// return what we got.
$arr["display"] = $meta["dispLink"];
sendXML(true, $arr);

function sendXML($msg = null, $arr = null)
{
  header("Content-type: text/xml");
  echo "<?xml version=\"1.0\"?>\n";
  echo "<blenzaplus>\n";
  if (($msg !== null)&&($msg !== true)) echo "<error>{$msg}</error>\n";
  else echo "<status>OK</status>\n";
  if ($arr != null) foreach ($arr as $key => $value) {
      echo "<{$key}>" . htmlentities($value) . "</{$key}>\n";
    }
  echo "</blenzaplus>\n";
  die;
}
?>