<?php
/*
Plugin Name: BlenzaPlus Linky Widget
Version: 1.1
Plugin URI: http://www.misterlinky.net/blenzaplus/
Description: Mister Linky brings the Linky Widget to your own server with the BlenzaPlus Linky Widget for WordPress.
Author: Mister Linky's Magical Widgets
Author URI: http://www.misterlinky.net/blenzaplus/
License: Please see license.txt for license terms.
*/

// TODO: put this back at the end of the description:
// ' Now with thumbnails!'

// make sure there is a session we can use.
if ( !session_id() ) session_start();

include "defines.php";
include "globals.php";

// don't do anything outside of the wordpress plugin framework.
if (!function_exists("add_action")) die("Oopsies!");

// tell wordpress about our activation hook.
register_activation_hook(__FILE__, 'blenzaplus_install');

// tell wordpress about our initialization action.
add_action("init", "blenzaplus_initAction");

function blenzaplus_getupdate($url)
{
  // if so, get the contents of the update status record
  $file = file_get_contents($url);
  error_log("update file has ".strlen($file)." bytes");
  list($http, $status, $str) = explode(" ", $http_response_header[0]);
  if ($status != 200) return null;

  // and return it in object form.
  return unserialize($file);
}

function blenzaplus_checkUpdate()
{
  // get the BlenzaPlus key; if we don't have one, fail.
  $key = get_option("blenzaplus_key");
  if (($key === null) || (strlen($key) == 0)) return false;

  // only need to check for udpates if it's the administrator
  if (!blenzaplus_isAdmin()) return true;

  // if it's been less than a few days, no need to bother.
  $checked = get_option("blenzaplus_checked");
  if (($checked + 302400) > time()) return true;

  // try and get the update from the primary server.
  $update = blenzaplus_getupdate("http://www.blenza.com/linkies/bp_update.php?key={$key}");
  if ($update != null) return $update;

  // if that didn't work, get the update from the secondary server.
  if ($update == null) $update = blenzaplus_getupdate("http://www.misterlinky.net/blenzaplus/bp_update.php?key={$key}");
  if ($update != null) return $update;

  // if that didn't work, defer update processing for now.
  return true;
}

function blenzaplus_install($force = false)
{
  global $wpdb, $blenzaplus_homeDir;

  $sql0 = file_get_contents("{$blenzaplus_homeDir}/database.sql");
  $sql = str_replace('{$wpdb->prefix}', $wpdb->prefix, $sql0);

  require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
  dbDelta($sql);

  update_option("blenzaplus_database", md5($sql0));
}

// our initialization action
function blenzaplus_initAction()
{
  // we shouldn't have gotten here without some key timestamps set up.
  $now = time();
  if (get_option("blenzaplus_checked") == null) update_option("blenzaplus_checked", $now);
  if (get_option("blenzaplus_latest") == null) update_option("blenzaplus_latest", $now);
  if (get_option("blenzaplus_updated") == null) update_option("blenzaplus_updated", $now);
  if (get_option("blenzaplus_expiry") == null) update_option("blenzaplus_expiry", $now + 1209600);

  if (get_option("timezone_string") != null) {
    date_default_timezone_set(get_option("timezone_string"));
  }

  // tell wordpress about the rest of our actions.
  add_action("admin_menu", "blenzaplus_adminAction");
  add_action("wp_print_scripts", "blenzaplus_scripts");
  add_filter("the_content", "blenzaplus_contentAction");
  add_action("save_post", "blenzaplus_savePostAction");
  add_action("comment_form", "blenzaplus_commentForm");
  add_action("comment_post", "blenzaplus_commentPost");
  add_action("preprocess_comment", "blenzaplus_commentPre");
}

// our content action
function blenzaplus_contentAction($content)
{
  // make sure we're properly set up.
  if (!blenzaplus_checkstatus()) return $content;

  // capture this moment in time.
  $now = time();

  // figure out where we are
  $postid = blenzaplus_postId();

  // use output buffering
  ob_start();

  // get our post metadata
  $metaStr = get_post_meta($postid, "blenzaplus_meta", true);
  if (strlen($metaStr) == 0) $meta = array();
  else $meta = unserialize($metaStr);

  // display the widget if it is enabled
  if ($meta["enabled"]) blenzaplus_displayWidget($postid);

  // if this is the administrator, offer to change settings.
  if (blenzaplus_isAdmin()) {
    // figure out if we're adding a selector (admin-only)
    $selector = get_option("blenzaplus_selector");
    if ($selector == null) $selector = "yes";
    if ($selector == "yes") blenzaplus_selector(blenzaplus_postId());
  }

  // if there is an external widget, let the administrator know about it.
  if (blenzaplus_isAdmin()) {
    $post = get_post($postid);
    $ext = blenzaplus_externalWidgetCheck($post->post_content);
    if ($ext && !$meta["ignoreExternal"]) {
      blenzaplus_msg("This post contains an external widget that can be imported to your server and converted to a BlenzaPlus Linky Widget.<br>Click <span style='text-decoration:underline;cursor:pointer' onclick='blenzaplus_convertExternalBegin({$postid})'>here</span> to learn more or click <span style='text-decoration:underline;cursor:pointer' onclick='blenzaplus_ignoreExternal({$postid})'>here</span> to ignore the external widget in this post and disable this message.", null, "blenzaplus_ignoreExternal{$postid}");
    }
  }

  $out = ob_get_contents();
  ob_end_clean();

  // return the original content plus the code for our widget.
  return $content . $out;
}

// display a widget.
function blenzaplus_displayWidget($postid)
{
  global $blenzaplus_homeDir, $blenzaplus_homeUrl;

  // capture this moment in time.
  $now = time();

  // get our post metadata
  $metaStr = get_post_meta($postid, "blenzaplus_meta", true);
  if (strlen($metaStr) == 0) $meta = array();
  else $meta = unserialize($metaStr);

  // load up the global and post-specific metadata
  include "metadata.php";

  // get the "extra" box share setting
  $exshow = $meta["exshow"];

  // get the links from the database
  global $wpdb;
  $links = $wpdb->get_results("select * from {$wpdb->prefix}blenzaplusLinks where post = {$postid} order by id asc");

  list($alignmentStr, $alignment) = blenzaplus_getAlignment();

  // get the widget content itself.
  echo "<table style='border:0;margin:0;padding:0;width:100%' border='0' cellpadding='0' cellspacing='0'><tr style='border:0;margin:0;padding:0'><td style='border:0;margin:0;padding:0' align='{$alignment}'>";
  include "widget-top.php";
  if ($widget != null) include "widget-body.php";

  if (!$meta["enabled"] || $ended || !$started || ($meta["endsat"] != null)) {
    //echo "<hr>";
    echo "<p style='text-align:center'><span class='blenzaplus_text'>";
    //echo "<p class='blenzaplus_text' style='text-align:center'>";
    echo "<small>";
    echo "This ";
    if ($meta["enabled"]) echo "event"; else echo "widget";
    echo " ";
    if (!$meta["enabled"]) {
      echo "is not yet enabled";
    }
    else if ($ended) {
      $whenn = $meta["endsat"];
      echo "ended " . blenzaplus_timeDiff($now, $meta["endsat"]). " ago";
    }
    else if (!$started) {
      $whenn = $meta["startsat"];
      echo "will start in " . blenzaplus_timeDiff($now, $meta["startsat"]);
    }
    else if ($meta["endsat"] != null) {
      $whenn = $meta["endsat"];
      echo "will end in " . blenzaplus_timeDiff($now, $meta["endsat"]);
    }
    //echo strftime(" on %A, %B %e, %Y at %l:%M %p", $whenn);
    echo ".";
    echo "</small>";
    //echo "</p>";
    echo "</span></p>";
  }

  include "widget-links.php";

  if ($meta["enabled"] && $started && !$ended) {
    if ($comments != "yes") include "widget-entry.php";
    else include "widget-comment.php";
  }

  include "widget-user.php";
  include "widget-admin.php";

  include "widget-bot.php";
  echo "</td></tr></table>";
}

// print the selector for this post.
function blenzaplus_selector($n = null)
{
  if ($n === null) $curval = "";
  else {
    $metaStr = get_post_meta($n, "blenzaplus_meta", true);
    if (strlen($metaStr) == 0) $meta = array();
    else $meta = unserialize($metaStr);
    if ($meta["enabled"] == 0) $curval = "";
    else if ($meta["widget"] == null) $curval = "plain";
    else $curval = $meta["widget"];
  }

  global $wpdb;
  $widgets = $wpdb->get_results("select * from {$wpdb->prefix}blenzaplusWidgets");

  $msg = "Blog Administrator: Click to change <a target='_blank'";
  if ($n !== null) {
    $msg .= " href='" .WP_ADMIN_URL. "/post.php?action=edit&post={$n}#blenzaplus'";
  }
  else {
    $msg .= " onclick='return false;'";
  }
  $msg .= ">widget settings</a>.<br>Or select a widget from the list. ";
  $msg .= "<select id='blenzaplus_selector";
  if ($n !== null) $msg .= $n;
  $msg .= "' style='height:20px;font-size:10px;padding:0px'>";
  $msg .= "<option";
  if ($curval == "") $msg .= " selected";
  $msg .= " value=''>No widget</option>";
  $msg .= "<option";
  if ($curval == "plain") $msg .= " selected";
  $msg .= " value='plain'>Plain widget</option>";
  foreach ($widgets as $widget) {
    $msg .= "<option";
    if ($curval == $widget->id) $msg .= " selected";
    $msg .= " value='";
    $msg .= $widget->id;
    $msg .= "'>";
    $msg .= htmlentities($widget->name);
    $msg .= "</option>";
  }
  $msg .= "<option value='edit'>Edit widgets...</option>";
  $msg .= "</select>";
  $msg .= " ";
  $msg .= "<input style='height:20px;font-size:10px;padding:0px' type='button' value='Set' onclick='blenzaplus_selected(";
  if ($n !== null) $msg .= $n;
  $msg .= ")'>";
  blenzaplus_msg($msg);
}

// scripts needed by the widget (just one to a page)
function blenzaplus_scripts()
{
  global $blenzaplus_homeDir, $blenzaplus_homeUrl;

  include "scripts.php";
  list($colorsStr, $colors) = blenzaplus_getColors();
  list($widthStr, $width) = blenzaplus_getWidth();
  list($fontStr, $font) = blenzaplus_getFontFamily();
  list($fsizeStr, $fsize) = blenzaplus_getFontSize();
  include "styles.php";
}

// our admin menu action
function blenzaplus_adminAction()
{
  global $blenzaplus_homeDir, $blenzaplus_homeUrl;

  // see if the update has been set up.
  $update = blenzaplus_checkUpdate();
  $status = blenzaplus_processUpdate($update);

  add_submenu_page("plugins.php", "BlenzaPlus Configuration", "<img width='12' height='12' src='{$blenzaplus_homeUrl}/images/linkarrow24.png'> BlenzaPlus Configuration", 8, __FILE__, "blenzaplus_pluginsPage");

  add_filter("manage_posts_columns", "blenzaplus_posts_columns");
  add_action("manage_posts_custom_column", "blenzaplus_custom_column");
  add_action("simple_edit_form", "blenzaplus_editFormAction");
  add_action("edit_page_form", "blenzaplus_editFormAction");
  add_action("edit_form_advanced", "blenzaplus_editFormAction");
}

// our post editing form action
function blenzaplus_editFormAction()
{
  global $blenzaplus_homeDir, $blenzaplus_homeUrl;

  // make sure we're properly set up.
  if (get_option("blenzaplus_key") == null) {
    ob_start();
    include "registration.php";
    $out = ob_get_contents();
    ob_end_clean();
    blenzaplus_box($out);
    return;
  }
  else if (get_option("blenzaplus_error") != null) {
    ob_start();
    echo "<p style=\"color:red\">Internal error: <i>".get_option("blenzaplus_error")."</i></p>";
    $out = ob_get_contents();
    ob_end_clean();
    blenzaplus_box($out);
    return;
  }
  else if (!blenzaplus_checkstatus()) {
    ob_start();
    $now = time();
    $expiry = get_option("blenzaplus_expiry");
    include "registration-done.php";
    $out = ob_get_contents();
    ob_end_clean();
    blenzaplus_box($out);
    return;
  }

  global $blenzaplus_newHintName, $blenzaplus_missingName;
  global $blenzaplus_newHintDesc, $blenzaplus_missingDesc;
  global $blenzaplus_newHintVader, $blenzaplus_missingVader;

  // capture this moment in time.
  $now = time();

  // figure out where we are
  $postid = blenzaplus_postId();

  // use output buffering
  ob_start();

  // if there are any errors to display, do that now.
  if (isset($_SESSION["blenzaplus_editFormError"])) {
    echo "<p style='color:red'>{$_SESSION["blenzaplus_editFormError"]}</p>";
    unset($_SESSION["blenzaplus_editFormError"]);
  }

  // get our post metadata
  $metaStr = get_post_meta(blenzaplus_postId(), "blenzaplus_meta", true);
  if (strlen($metaStr) == 0) $meta = array();
  else $meta = unserialize($metaStr);

  // if it's blank, we should ask the administrator what to do.
  if (strlen($metaStr) == 0) {
    $checked = "";
  }
  else {
    $meta = unserialize($metaStr);
    $checked = $meta["enabled"] ? "checked" : "";
  }

  global $wpdb;
  $widgets = $wpdb->get_results("select * from {$wpdb->prefix}blenzaplusWidgets");

  include "editform.php";

  $post = get_post($postid);
  $ext = blenzaplus_externalWidgetCheck($post->post_content);
  if ($ext) {
    $extCode = blenzaplus_externalWidgetCode($post->post_content);
    include "editform-external.php";
    include "editform-external-scripts.php";
  }

  $convertPhase = blenzaplus_stripRequest("blenzaplus_external");
  include "editform-scripts.php";

  $out = ob_get_contents();
  ob_end_clean();

  blenzaplus_box($out);
}

// our post editing save action
function blenzaplus_savePostAction($id)
{
  // make sure we're properly set up.
  if (!blenzaplus_checkstatus()) return;

  // if our hidden field is missing, we don't want to get involved
  if ($_POST["blenzaplus_ui"] == null) return;

  // see if thumbnails are even configured
  $thumbsOn = (get_option("blenzaplus_thumbs") == "yes");

  global $blenzaplus_newHintName, $blenzaplus_missingName;
  global $blenzaplus_newHintDesc, $blenzaplus_missingDesc;
  global $blenzaplus_newHintVader, $blenzaplus_missingVader;

  // snap the current date/time, in case we need it.
  $curtime = strftime("%m/%d/%y %I:%M %p");

  // get our post metadata
  $metaStr = get_post_meta($id, "blenzaplus_meta", true);
  if (strlen($metaStr) == 0) $meta = array();
  else $meta = unserialize($metaStr);

  // figure out what the user wants to do.
  if (isset($_POST["blenzaplus_enableWidget"])) $enabled = true;
  else $enabled = false;
  $meta["enabled"] = $enabled;

  // if we're adding a new widget, do that now.
  if ($_POST["blenzaplus_selectWidget"] == "NEW") {
    $newName = blenzaplus_stripRequest("blenzaplus_newWidgetName");
    $newDesc = blenzaplus_stripRequest("blenzaplus_newWidgetDesc");
    $newVader = blenzaplus_stripRequest("blenzaplus_newWidgetVader");

    // if it's the name or description we loaded as a hint, that doesn't count
    if ($newName == $blenzaplus_newHintName) {
      $_SESSION["blenzaplus_editFormError"] = $blenzaplus_missingName;
      return;
    }
    if ($newDesc == $blenzaplus_newHintDesc) {
      $_SESSION["blenzaplus_editFormError"] = $blenzaplus_missingDesc;
      return;
    }
    if ($newVader == $blenzaplus_newHintVader) {
      $newVader = null;
    }

    if (($newVader != null) && !blenzaplus_isOption("connect")) sendError("Cannot set validator with connect disabled");

    // add it to the widgets table.
    global $wpdb;
    $row = array
      (
       "name" => $newName,
       "description" => $newDesc,
       "validator" => $newVader,
       );
    $wpdb->insert("{$wpdb->prefix}blenzaplusWidgets", $row);

    // and use the one we've just created.
    $meta["widget"] = $wpdb->insert_id;
  }

  // otherwise use the existing one the user chose.
  else $meta["widget"] = blenzaplus_stripRequest("blenzaplus_selectWidget");

  // set the starting date/time, if any.
  $starts = $_POST["blenzaplus_starts"];
  if ($starts == null) $starts = "started";
  $meta["starts"] = $starts;

  if ($starts == "specify") {
    $startsat = $_POST["blenzaplus_startsat"];
    if ($startsat == null) $startsat = $curtime;
    $meta["startsat"] = blenzaplus_cvtime($startsat);
  }
  else $meta["startsat"] = null;

  // set the ending date/time, if any.
  $ends = $_POST["blenzaplus_ends"];
  if ($ends == null) $ends = "ended";
  $meta["ends"] = $ends;

  if ($ends == "specify") {
    $endsat = $_POST["blenzaplus_endsat"];
    if ($endsat == null) $endsat = $curtime;
    $meta["endsat"] = blenzaplus_cvtime($endsat);
    $meta["endsin"] = null;
  }
  else if ($ends == "after") {
    $endsin = $_POST["blenzaplus_endsin"];
    if ($endsin == null) $endsin = 0;
    $meta["endsin"] = $endsin;
    $meta["endsat"] = $meta["startsat"] + ($endsin * 60 * 60 * 24);
  }
  else {
    $meta["endsat"] = null;
    $meta["endsin"] = null;
  }

  // set the number of columns.
  $columns = get_option("blenzaplus_columns");
  if ($columns == null) $columns = 3;
  if (isset($_POST["blenzaplus_columns"])) $columns = $_POST["blenzaplus_columns"];
  $meta["columns"] = $columns;

  // set the "extra" box
  $extra = get_option("blenzaplus_extra");
  if ($extra == null) $extra = "no";
  if (isset($_POST["blenzaplus_extra"])) $extra = $_POST["blenzaplus_extra"];
  $meta["extra"] = $extra;

  // set the "extra" box description
  $exdesc = blenzaplus_stripRequest("blenzaplus_exdesc");
  $meta["exdesc"] = $exdesc;

  // set the "extra" box share setting
  $exshow = $_POST["blenzaplus_exshow"];
  $meta["exshow"] = $exshow;

  if ($thumbsOn) {
    // set the thumbnails
    $thumbs = get_option("blenzaplus_thumbs");
    if ($thumbs == null) $thumbs = "no";
    if (isset($_POST["blenzaplus_thumbs"])) $thumbs = $_POST["blenzaplus_thumbs"];
    $meta["thumbs"] = $thumbs;

    // set the thumbnails required setting
    $threqd = $_POST["blenzaplus_threqd"];
    $meta["threqd"] = $threqd;

    // set the thumbnails approval setting
    $thaprv = $_POST["blenzaplus_thaprv"];
    $meta["thaprv"] = $thaprv;
  }
  else {
    $meta["thumbs"] = "no";
    $meta["threqd"] = "yes";
    $meta["thaprv"] = "yes";
  }

  // get the post object
  $post = get_post($id);

  // if the widget wasn't already set up when we got here and the post
  // has been published, see if the title matches one of our widgets.
  if (($post->post_status == "publish") && (strlen($metaStr) == 0)) {

    // get the array of widgets
    global $wpdb;
    $widgets = $wpdb->get_results("select * from {$wpdb->prefix}blenzaplusWidgets order by id desc");

    // test each one
    foreach ($widgets as $widget) {
      // if the match string is lower case, do the whole comparison in
      // lower case; otherwise do a natural match
      if ($widget->auto_match == strtolower($widget->auto_match)) {
        $haystack = strtolower($post->post_title);
        $needle = strtolower($widget->auto_match);
      }
      else
      {
        $haystack = $post->post_title;
        $needle = $widget->auto_match;
      }
      if ($needle == null) continue;
      $pos = strpos($haystack, $needle);
      error_log("orig: title=/{$post->post_title}/ match=/{$widget->auto_match}/");
      error_log("match: titlep=/{$haystack}/ match=/{$needle}/");
      error_log("pos: {$pos}");
      if ($pos !== false) {
        $meta["enabled"] = true;
        $meta["widget"] = $widget->id;
        break;
      }
    }
  }

  // add or update the metadata for this post, but not if we're
  // disabled and there was no metadata when we got here.
  if (strlen($metaStr) == 0) {
    if ($meta["enabled"]) {
      $metaStr = get_post_meta(blenzaplus_postId(), "blenzaplus_meta", true);
      if (strlen($metaStr) == 0) {
        add_post_meta($id, "blenzaplus_meta", serialize($meta));
      }
      else {
        update_post_meta($id, "blenzaplus_meta", serialize($meta));
      }
    }
  }
  else {
    update_post_meta($id, "blenzaplus_meta", serialize($meta));
  }
}

// called to create the comment form
function blenzaplus_commentForm()
{
  global $blenzaplus_backbuttonStyle, $blenzaplus_checkboxStyle, $blenzaplus_inputStyle;
  global $blenzaplus_homeDir, $blenzaplus_homeUrl;

  // make sure we're properly set up.
  if (!blenzaplus_checkstatus()) return;

  // capture this moment in time.
  $now = time();

  // figure out where we are
  $postid = blenzaplus_postId();

  // get our post metadata
  $metaStr = get_post_meta(blenzaplus_postId(), "blenzaplus_meta", true);
  if (strlen($metaStr) == 0) $meta = array();
  else $meta = unserialize($metaStr);

  // display the widget if it is enabled
  if ($meta["enabled"]) {
    // load up the global and post-specific metadata
    include "metadata.php";

    // if the event has ended or not started, nothing to see here.
    if ($ended || !$started) return;

    // and if we're using the widget entry form, we're done here.
    if ($comments != "yes") return;

    // get information about the user
    global $current_user;
    get_currentuserinfo();

    // get the widget content itself.
    echo "\n<br clear='all'><br>\n";
    echo "<div id=\"blenzaplus_div" . blenzaplus_postId() . "\">";
    include "widget-top.php";
    if ($widget != null) include "widget-body.php";
    include "widget-comment-form.php";
    include "widget-bot.php";
    echo "</div>";

    if ($thumbs == "yes") {
      echo "<div id=\"blenzaplus_thm" . blenzaplus_postId() . "\">";
      echo "<table>";
      include "widget-thumbs.php";
      echo "</table>";
      echo "</div>";
    }

    include "widget-comment-script.php";
  }
}

// comment pre-processor
function blenzaplus_commentPre($comment)
{
  error_log("in blenzaplus_commentPre with ".print_r($_REQUEST, true));

  // make sure we're properly set up.
  if (!blenzaplus_checkstatus()) return $comment;

  // make sure it's a valid URL we're looking at
  $link = $comment["comment_author_url"];
  if ($link != null) {
    // check the link, non-array means error
    $parse = blenzaplus_checkLink($link);
    if (!is_array($parse)) wp_die($parse);
    $comment["blenzaplus_parse"] = $parse;
    if (blenzaplus_isOption("connect")) {
      // check the connection, non-array means error
      $site = blenzaplus_connectLink($link);
      if (!is_array($site)) wp_die($site);
      $comment["blenzaplus_status"] = $site["status"];
      $comment["blenzaplus_content"] = $site["content"];
    }
  }

  // check for valid data
  $op = blenzaplus_stripRequest('blenzaplus_inp_op');
  $comment["blenzaplus_thumbOp"] = $op;
  if ($op) {
    $thint = get_option("blenzaplus_thumbInt");
    if ($thint == null) wp_die("Thumbnails configuration is incomplete");

    if ($op == "file") {
      $image = $_FILES["blenzaplus_imageFile"];
      if ($image === null) wp_die("Missing image.");
      if ($image["name"] == null) wp_die("Missing image.");
      if ($image["type"] == null) wp_die("Missing image.");
      if ($image["size"] == null) wp_die("Missing image.");
      if (!is_uploaded_file($image["tmp_name"])) wp_die("Illegal upload");
    }
    else if (($op == "site") || ($op == "url") || ($op == "gravatar")) {
      if ($op == "site") {
        $image = blenzaplus_stripRequest("blenzaplus_imageSite");
        if ($image == null) wp_die("Please click an image.");
      }
      else if ($op == "url") {
        $image = blenzaplus_stripRequest("blenzaplus_imageURL");
        if ($image == null) wp_die("Please enter the URL of an image.");
      }
      else if ($op == "gravatar") {
        $email = blenzaplus_stripRequest("blenzaplus_email");
        if ($email == null) wp_die("Please enter your e-mail address.");
        $image = "http://www.gravatar.com/avatar/"
          . md5(strtolower(trim($email)))
          . "?s=75.jpg";
      }
    }
    $comment["blenzaplus_thumbImage"] = $image;
  }

  // stash the comment so we can get the name/link later
  global $blenzaplus_commentSave;
  $blenzaplus_commentSave = $comment;
  return $comment;
}

// comment processor
function blenzaplus_commentPost($commentId)
{
  // make sure we're properly set up.
  if (!blenzaplus_checkstatus()) return;

  global $blenzaplus_commentSave;
  error_log("we're into commentPost with ".print_r($blenzaplus_commentSave, true));

  // make sure we have a post id.
  $postid = $_REQUEST["comment_post_ID"];
  if ($postid == null) return;

  // if they didn't checked the box, there is nothing to do.
  $check = $_REQUEST["blenzaplus_participant{$postid}"];
  if ($check != "on") return;

  // grab the name/linky from the stashed comment array
  $name = stripslashes($blenzaplus_commentSave["comment_author"]);
  $url = $blenzaplus_commentSave["comment_author_url"];

  // get the content of the extra box.
  $extra = blenzaplus_stripRequest("blenzaplus_extra{$postid}");

  // address of the client
  $ipaddr = $_SERVER["REMOTE_ADDR"];

  // http status if we connected to the URL
  if (blenzaplus_isOption("connect")) {
    $status = $blenzaplus_commentSave["blenzaplus_status"];
  }
  else $status = null;

  // pass content down if we connected
  if (blenzaplus_isOption("connect")) {
    $content = $blenzaplus_commentSave["blenzaplus_content"];
  }
  else $content = null;

  // perform content validation
  $parse = $blenzaplus_commentSave["blenzaplus_parse"];
  $host = $parse["host"];
  $error = blenzaplus_validation($postid, $name, $host, $status, $content);

  // think up a secret random number to share with the thumbnail code
  // not sure how to get it there yet, but...
  $secret = rand();

  // get our saved thumbnail data
  $op = $blenzaplus_commentSave["blenzaplus_thumbOp"];
  if ($op) {
    $image = $blenzaplus_commentSave["blenzaplus_thumbImage"];
  }

  // if there is an image, approval is negative; if not just nothing.
  $approved = ($op) ? -1 : 0;

  // insert it into the database.
  $linkid = blenzaplus_insertLink($postid, $name, $url, $extra, $ipaddr, $secret, $approved, $error);

  // if there's no thumbnail, we're done.
  if (!$op) return;

  // and create the thumbnail to go with it.
  blenzaplus_createThumbnail($postid, $linkid, $op, $image);
}

// helper to pick a regular expression delimiter for our validator
function blenzaplus_getPregDelim($pat)
{
  if (strpos($pat, "~") === false) return "~";
  if (strpos($pat, "`") === false) return "`";
  if (strpos($pat, "@") === false) return "@";
  if (strpos($pat, "#") === false) return "#";
  if (strpos($pat, "&") === false) return "&";
  if (strpos($pat, "|") === false) return "|";
  return null;
}

// our plugin options sub-page
function blenzaplus_pluginsPage()
{
  global $blenzaplus_homeDir, $blenzaplus_homeUrl;

  // make sure we're the admin like we're supposed to be
  check_admin_referer();

  // perform any updates that have been posted

  if (isset($_POST["blenzaplus_key"])) {
    update_option("blenzaplus_key", $_POST["blenzaplus_key"]);
    update_option("blenzaplus_checked", 0);
  }
  if (isset($_POST["blenzaplus_target"])) {
    update_option("blenzaplus_target", $_POST["blenzaplus_target"]);
  }
  if (isset($_POST["blenzaplus_nofollow"])) {
    update_option("blenzaplus_nofollow", $_POST["blenzaplus_nofollow"]);
  }
  if (isset($_POST["blenzaplus_selector"])) {
    update_option("blenzaplus_selector", $_POST["blenzaplus_selector"]);
  }
  if (isset($_POST["blenzaplus_repeat"])) {
    update_option("blenzaplus_repeat", $_POST["blenzaplus_repeat"]);
  }
  if (isset($_POST["blenzaplus_connect"])) {
    update_option("blenzaplus_connect", $_POST["blenzaplus_connect"]);
  }
  if (isset($_POST["blenzaplus_colors"])) {
    $colors = $_POST["blenzaplus_colors"];
    if ($colors == "custom") {
      $fore = null;
      $back = null;
      if (isset($_POST["blenzaplus_colorCode_fore"])) {
        $fore = $_POST["blenzaplus_colorCode_fore"];
      }
      if (isset($_POST["blenzaplus_colorCode_back"])) {
        $back = $_POST["blenzaplus_colorCode_back"];
      }
      $colorsArr = array("fore"=>$fore, "back"=>$back);
      $colors = serialize($colorsArr);
    }
    update_option("blenzaplus_colors", $colors);
  }
  if (isset($_POST["blenzaplus_font"])) {
    $font = $_POST["blenzaplus_font"];
    if ($font == "custom") {
      $val = null;
      if (isset($_POST["blenzaplus_fontVal"])) {
        $val = $_POST["blenzaplus_fontVal"];
      }
      $font = serialize($val);
    }
    update_option("blenzaplus_font", $font);
  }
  if (isset($_POST["blenzaplus_fsize"])) {
    $fsize = $_POST["blenzaplus_fsize"];
    if ($fsize == "custom") {
      $val = null;
      if (isset($_POST["blenzaplus_fsizeVal"])) {
        $val = $_POST["blenzaplus_fsizeVal"];
      }
      $fsize = serialize($val);
    }
    update_option("blenzaplus_fsize", $fsize);
  }
  if (isset($_POST["blenzaplus_width"])) {
    $width = $_POST["blenzaplus_width"];
    if ($width == "custom") {
      $val = null;
      if (isset($_POST["blenzaplus_widthVal"])) {
        $val = $_POST["blenzaplus_widthVal"];
      }
      $width = serialize($val);
    }
    update_option("blenzaplus_width", $width);
  }
  if (isset($_POST["blenzaplus_alignment"])) {
    $alignment = $_POST["blenzaplus_alignment"];
    if ($alignment == "custom") {
      $val = null;
      if (isset($_POST["blenzaplus_alignmentVal"])) {
        $val = $_POST["blenzaplus_alignmentVal"];
      }
      $alignment = serialize($val);
    }
    update_option("blenzaplus_alignment", $alignment);
  }
  if (isset($_POST["blenzaplus_columns"])) {
    update_option("blenzaplus_columns", $_POST["blenzaplus_columns"]);
  }
  if (isset($_POST["blenzaplus_comments"])) {
    update_option("blenzaplus_comments", $_POST["blenzaplus_comments"]);
  }
  if (isset($_POST["blenzaplus_extra"])) {
    update_option("blenzaplus_extra", $_POST["blenzaplus_extra"]);
  }
  if (isset($_POST["blenzaplus_exdesc"])) {
    update_option("blenzaplus_exdesc", $_POST["blenzaplus_exdesc"]);
  }
  if (isset($_POST["blenzaplus_exshow"])) {
    update_option("blenzaplus_exshow", $_POST["blenzaplus_exshow"]);
  }
  if (isset($_POST["blenzaplus_thumbs"])) {
    update_option("blenzaplus_thumbs", $_POST["blenzaplus_thumbs"]);
  }
  if (isset($_POST["blenzaplus_threqd"])) {
    update_option("blenzaplus_threqd", $_POST["blenzaplus_threqd"]);
  }
  if (isset($_POST["blenzaplus_thaprv"])) {
    update_option("blenzaplus_thaprv", $_POST["blenzaplus_thaprv"]);
  }
  if (isset($_POST["blenzaplus_thint"])) {
    update_option("blenzaplus_thumbInt", $_POST["blenzaplus_thint"]);
  }
  if (isset($_POST["blenzaplus_thext"])) {
    update_option("blenzaplus_thumbExt", $_POST["blenzaplus_thext"]);
  }
  if (isset($_POST["blenzaplus_donated"])) {
    update_option("blenzaplus_donated", $_POST["blenzaplus_donated"]);
  }

  // display the form, located in an include file.
  include "config-body.php";
  include "config-scripts.php";
}

function blenzaplus_posts_columns($posts_columns)
{
  global $blenzaplus_homeUrl;

  $posts_columns["blenzaplus"] = "<img width='12' height='12' src='{$blenzaplus_homeUrl}/images/linkarrow24.png'> Linky";
  return $posts_columns;
}

function blenzaplus_custom_column($custom_column)
{
  if ($custom_column != "blenzaplus") return;

  // get our post metadata
  $metaStr = get_post_meta(blenzaplus_postId(), "blenzaplus_meta", true);
  if (strlen($metaStr) == 0) $meta = array();
  else $meta = unserialize($metaStr);

  // if not, just say so and return.
  if (!$meta["enabled"]) {
    echo "<span style='color:red'>None</span>";
    return true;
  }

  $widget = blenzaplus_getWidget($meta["widget"]);

  echo "<span style='color:green'>";
  echo (strlen($widget->name) > 0) ? $widget->name : "<i>Unnamed</i>";
  echo "</span>";

  return true;
}

// {$vc} = "[^&\"'<>]"; // Value Character
// {$qq} = "[\"']"; // Quote character
// {$iq} = "[^\"']"; // stay In Quote
// {$it} = "[^>]"; // stay In Tag
// {$ot} = "[^<]"; // stay Out of Tag

$blenzaplus_externalPatterns = Array(
  // linkyktools widgets
  "<script[^>]*((mcklinky|linkytools)\.com)/[^>]*\?id=([^&\"'<>]*)[^>]*>[^<]*</script>",
  // simply-linked widgets
  "<script[^>]*(simply-linked\.com)/[^>]*\?l=([^&\"'<>]*)[^>]*>[^<]*</script>",
  // blenza script widgets
  "(<div[^>]*preview[^>]*>.*</div>.*|)<script[^>]*(blenza\.com)/[^>]*\?owner=([^&\"'<>]*).*postid=([^&\"'<>]*).*meme=([^&\"'<>]*)[^>]*>[^<]*</script>",
  "(<div[^>]*preview[^>]*>.*</div>.*|)<script[^>]*(blenza\.com)/[^>]*\?owner=([^&\"'<>]*).*postid=([^&\"'<>]*)[^>]*>[^<]*</script>",
  // blenza graphical widgets
  "<a.*(blenza\.com)/.*links.php\?owner=([^&\"'<>]*).*postid=([^&\"'<>]*).*meme=([^&\"'<>]*)[^>][^>]*><img.*blenza.com/.*graphic.php\?owner=([^&\"'<>]*).*postid=([^&\"'<>]*).*meme=([^&\"'<>]*)[^>][^>]*></a>",
  "<a.*(blenza\.com)/.*links.php\?owner=([^&\"'<>]*).*postid=([^&\"'<>]*)[^>][^>]*><img.*blenza.com/.*graphic.php\?owner=([^&\"'<>]*).*postid=([^&\"'<>]*)[^>][^>]*></a>",
  );

// pattern for Linkytools widget.
$blenzaplus_externalPat1 = "<li[^>]*>[^<]*<a[^>]*href=[\"']([^\"']*)[\"'][^>]*><span>([^<]*)</span></a></li>";

// pattern for Simply-Linked widget.
$blenzaplus_externalPat2 = "<td[^>]*>[^<]*<a[^>]*href=[\"']([^\"']*)[\"'][^>]*>([^<]*)</a></td>";

// function to look at some content and determine whether there is any
// external widget code in there.  if so, we will offer to import the
// links and convert to a widget that lives on the blog's own server.
function blenzaplus_externalWidgetCheck($in)
{
  global $blenzaplus_externalPatterns;
  foreach ($blenzaplus_externalPatterns as $i => $pat) {
    $mats = Array();

    // first, see if we find one of the
    $n = preg_match("~{$pat}~s", $in, $mats);

    // did we find anything?
    if ($n > 0) return true;
  }

  // if we have an old-style server-based Mister Linky widget. we'll
  // want to offer import of these as well, and since the interface
  // belongs to me, munging the WP metadata isn't really a big deal.
  $postid = blenzaplus_postId();
  $oldBlenzaMeme = get_post_meta($postid, "post_meme", true);
  $oldBlenzaUser = get_option("blenza_userid");
  if (($oldBlenzaMeme != null) && ($oldBlenzaMeme != -1) && ($oldBlenzaUser !== null)) return true;

  // if we haven't returned by now, the answer is no.
  return false;
}

function blenzaplus_externalWidgetCode($in)
{
  global $blenzaplus_externalPatterns, $blenzaplus_mlwp;
  foreach ($blenzaplus_externalPatterns as $i => $pat) {
    $mats = Array();

    // first, see if we find one of the
    $n = preg_match("~{$pat}~s", $in, $mats);

    // did we find anything?
    if ($n > 0) return $mats;
  }

  // if we have an old-style server-based Mister Linky widget. we'll
  // want to offer import of these as well, and since the interface
  // belongs to me, munging the WP metadata isn't really a big deal.
  $postid = blenzaplus_postId();
  $oldBlenzaMeme = get_post_meta($postid, "post_meme", true);
  $oldBlenzaUser = get_option("blenza_userid");
  if (($oldBlenzaMeme !== null) && ($oldBlenzaMeme != -1) && ($oldBlenzaUser !== null)) return Array($blenzaplus_mlwp, $oldBlenzaUser, $postid);

  // if we haven't returned by now, there is no code.
  return null;
}

function blenzaplus_externalWidgetLink($in)
{
  global $blenzaplus_mlwp, $blenzaplus_homeDir, $blenzaplus_homeUrl;

  $code = blenzaplus_externalWidgetCode($in);
  if ($code === null) return null;

  // if it's a linkytools a.k.a. mcklinky widget, all we need is the id part
  if (($code[1] == "linkytools.com") || ($code[1] == "mcklinky.com")) {
    if (count($code) == 4) return Array(
      "server" => "Linkytools",
      "root" => "http://www.linkytools.com/basic_linky_include.aspx?",
      "dispRoot" => "{$blenzaplus_homeUrl}/unscript.php?src=http://www.linkytools.com/basic_linky_include.aspx%3F",
      "params" => "id={$code[3]}"
      );
  }

  // if it's simply-linked, there is one parameter "l"
  if ($code[1] == "simply-linked.com") {
    if (count($code) == 3) return Array(
      "server" => "Simply-Linked",
      "root" => "http://www.simply-linked.com/listwidget.aspx?",
      "dispRoot" => "{$blenzaplus_homeUrl}/unscript.php?src=http://www.simply-linked.com/listwidget.aspx%3F",
      "params" => "l={$code[2]}"
      );
  }

  // if it's a blenza widget, we need the owner, postid, meme parts
  if ($code[1] == "blenza.com") {
    if (count($code) == 6) return Array(
      "server" => "Blenza",
      "root" => "http://www.blenza.com/linkies/ws_autolink.php?cv=003&",
      "dispRoot" => "http://www.blenza.com/linkies/links.php?",
      "params" => "owner={$code[2]}&postid={$code[3]}"
      );
    if (count($code) == 8) return Array(
      "server" => "Blenza",
      "root" => "http://www.blenza.com/linkies/ws_autolink.php?cv=003&",
      "dispRoot" => "http://www.blenza.com/linkies/links.php?",
      "params" => "owner={$code[2]}&postid={$code[3]}&meme={$code[4]}"
      );
  }
  if ($code[2] == "blenza.com") {
    if (count($code) == 5) return Array(
      "server" => "Blenza",
      "root" => "http://www.blenza.com/linkies/ws_autolink.php?cv=003&",
      "dispRoot" => "http://www.blenza.com/linkies/links.php?",
      "params" => "owner={$code[3]}&postid={$code[4]}"
      );
    if (count($code) == 6) return Array(
      "server" => "Blenza",
      "root" => "http://www.blenza.com/linkies/ws_autolink.php?cv=003&",
      "dispRoot" => "http://www.blenza.com/linkies/links.php?",
      "params" => "owner={$code[3]}&postid={$code[4]}&meme={$code[5]}"
      );
  }

  if ($code[0] == $blenzaplus_mlwp) {
    return Array(
      "server" => "Blenza",
      "root" => "http://www.blenza.com/linkies/ws_autolink.php?cv=003&",
      "dispRoot" => "http://www.blenza.com/linkies/links.php?",
      "params" => "owner={$code[1]}&postid={$code[2]}"
      );
  }

  return null;
}

// helper functions to print a message
function blenzaplus_msgTop($title = null, $id = null)
{
  global $blenzaplus_homeDir, $blenzaplus_homeUrl;

  if (!blenzaplus_isAdmin()) return;
?>
  <div <?php if ($id !== null) echo "id='{$id}'"; ?> class="blenzaplus_msg">
<img align="right" width="32" height="32" src="<?php echo $blenzaplus_homeUrl; ?>/images/linkarrow24.png"><h3>Linky Administrator</h3>
<div class="inside">
<?php if ($title != null) { ?>
<h4 style="background: #ffa900; color: #004c00; padding: 4px; margin: 4px 0px; text-align: center"><?php echo $title; ?></h4>
<?php } ?>
<?php
}

function blenzaplus_msgBot()
{
  if (!blenzaplus_isAdmin()) return;
?>
</div>
</div>
<?php
}

function blenzaplus_msg($content, $title = null, $id = null)
{
  if (!blenzaplus_isAdmin()) return;
  blenzaplus_msgTop($title, $id);
  echo $content;
  blenzaplus_msgBot();
}

// helper function to print stuff in a pretty box
function blenzaplus_box($content, $title = null)
{
  global $blenzaplus_homeDir, $blenzaplus_homeUrl;

?>

<a name="blenzaplus"></a>
<div id="categorydiv" class="postbox">
<h3>BlenzaPlus Linky Widget <img align="right" width="24" height="24" src="<?php echo $blenzaplus_homeUrl; ?>/images/linkarrow24.png"></h3>
<div class="inside">
<?php if ($title != null) { ?>
<h4 style="background: #ffa900; color: #004c00; padding: 4px; margin: 4px 0px; text-align: center"><?php echo $title; ?></h4>
<?php } ?>
<?php echo $content; ?>
</div>
</div>

<?php
}

// helper function to tell us the ID of the current post
function blenzaplus_postId()
{
  global $post;
  return $post->ID;
}

// helper function to tell us if the current user is the admin
function blenzaplus_isAdmin()
{
  return current_user_can("publish_posts");
}

// helper function to get our color pallette
function blenzaplus_getColors()
{
  $colorsStr = get_option("blenzaplus_colors");
  if ($colorsStr == null) $colorsStr = "bw";
  if ($colorsStr == "bw") {
    $colors = array("fore" => "#000000", "back" => "#ffffff");
  }
  else if ($colorsStr == "wb") {
    $colors = array("fore" => "#ffffff", "back" => "#000000");
  }
  else {
    $colors = unserialize($colorsStr);
    $colorsStr = "custom";
  }
  return array($colorsStr, $colors);
}

// helper function to get our widget width
function blenzaplus_getWidth()
{
  $widthStr = get_option("blenzaplus_width");
  if ($widthStr == null) $widthStr = "narrow";
  if ($widthStr == "narrow") {
    $width = 400;
  }
  else if ($widthStr == "wide") {
    $width = 600;
  }
  else {
    $width = unserialize($widthStr);
    $widthStr = "custom";
  }
  return array($widthStr, $width);
}

// helper function to get our alignment
function blenzaplus_getAlignment()
{
  $alignmentStr = get_option("blenzaplus_alignment");
  if ($alignmentStr == null) $alignmentStr = "left";
  $alignment = $alignmentStr;
  return array($alignmentStr, $alignment);
}

// helper function to get our font family
function blenzaplus_getFontFamily()
{
  $fontStr = get_option("blenzaplus_font");
  if ($fontStr == null) $fontStr = "plain";
  if ($fontStr == "plain") {
    $font = 'Arial,sans-serif';
  }
  else if ($fontStr == "fancy") {
    $font = '"Times New Roman",Georgia,serif';
  }
  else {
    $font = unserialize($fontStr);
    $fontStr = "custom";
  }
  return array($fontStr, $font);
}

// helper function to get our font size
function blenzaplus_getFontSize()
{
  $sizeStr = get_option("blenzaplus_fsize");
  if ($sizeStr == null) $sizeStr = "small";
  if ($sizeStr == "small") {
    $size = "10pt";
  }
  else if ($sizeStr == "large") {
    $size = "12pt";
  }
  else {
    $size = unserialize($sizeStr);
    $sizeStr = "custom";
  }
  return array($sizeStr, $size);
}

// helper function to get our widget from the database
function blenzaplus_getWidget($n)
{
  global $wpdb;
  $sql = $wpdb->prepare("select * from {$wpdb->prefix}blenzaplusWidgets where id = %d", $n);
  $widget = $wpdb->get_row($sql);
  return $widget;
}

// helper function to find a widget in the database
function blenzaplus_findWidget($n)
{
  global $wpdb;
  $sql = $wpdb->prepare("select * from {$wpdb->prefix}blenzaplusWidgets where name = %s", $n);
  $widget = $wpdb->get_row($sql);
  return $widget->id;
}

// helper function to add a widget to the database
function blenzaplus_insertWidget($name, $desc, $vader = null)
{
  // before we insert it, see if we already have it.
  $widget = blenzaplus_findWidget($name);
  if ($widget !== null) return $widget;

  global $wpdb;
  $row = array
    (
     "name" => $name,
     "description" => $desc,
     "validator" => $vader,
     );
  $wpdb->insert("{$wpdb->prefix}blenzaplusWidgets", $row);

  // and return what we've just created.
  return $wpdb->insert_id;
}

// helper function to convert a date/time to unix timestamp
function blenzaplus_cvtime($str)
{
  $mats = array();
  $mc = preg_match("|([0-9]+)/([0-9]+)/([0-9]+) ([0-9]+):([0-9]+) ([aAfpP][mM])|", $str, $mats);
  if ($mc == 1) {
    $hour = $mats[4];
    if ($hour == 12) $hour = 0;
    if (strtolower($mats[6]) == "pm") $hour += 12;
    $year = $mats[3];
    if (strlen($mats[3]) < 4) $year += 2000;
    $time = mktime($hour, $mats[5], 0, $mats[1], $mats[2], $year);
  }
  else {
    $time = strtotime($str);
    if ($time === false) return null;
  }
  return $time;
}

// helper function for dispalying an amount of time in years, weeks,
// days, hours, minutes and seconds
function blenzaplus_timeDiff($now, $then)
{
  $diff = $then - $now;
  $n = abs($diff);
  if ($diff == 0) $dir = 0; else $dir = $n / $diff;

  $year = floor($n / 60 / 60 / 24 / 365);
  if ($year > 0) {
    $d = getdate($now);
    $xt = mktime($d["hours"], $d["minutes"], $d["seconds"],
      $d["mon"], $d["mday"], $d["year"] + $dir * $year);
    if ((($dir > 0) && ($xt > $then)) || (($dir < 0) && ($then > $xt))) {
      $year--;
      $xt = mktime($d["hours"], $d["minutes"], $d["seconds"],
        $d["mon"], $d["mday"], $d["year"] + $dir * $year);
    }
    $n = $dir * ($then - $xt);
  }

  $month = floor($n / 60 / 60 / 24 / 28);
  if ($month > 0) {
    $d = getdate($now);
    for ($i = 0; ; $i++) {
      if ($i > 15) break;
      $xt = mktime($d["hours"], $d["minutes"], $d["seconds"],
        $d["mon"] + $dir * $i, $d["mday"], $d["year"] - $year);
      if ((($dir > 0) && ($xt > $then)) || (($dir < 0) && ($then > $xt))) {
        $month = $i - 1;
        $xt = mktime($d["hours"], $d["minutes"], $d["seconds"],
          $d["mon"] + $dir * $month, $d["mday"], $d["year"] - $year);
        break;
      }
    }
    $n = $dir * ($then - $xt);
  }

  $day = floor($n / 60 / 60 / 24);
  if ($day > 0) {
    $n -= ($day * 24 * 60 * 60);
  }
  $hour = floor($n / 60 / 60);
  if ($hour > 0) {
    $n -= ($hour * 60 * 60);
  }
  $minute = floor($n / 60);
  if ($minute > 0) {
    $n -= ($minute * 60);
  }
  $second = $n;
  $out = "";
  if ($year > 0) {
    if (strlen($out) > 0) $out .= ", ";
    $out .= $year;
    $out .= " year";
    if ($year != 1) $out .= "s";
  }
  if ($month > 0) {
    if (strlen($out) > 0) $out .= ", ";
    $out .= $month;
    $out .= " month";
    if ($month != 1) $out .= "s";
  }
  if ($day > 0) {
    if (strlen($out) > 0) $out .= ", ";
    $out .= $day;
    $out .= " day";
    if ($day != 1) $out .= "s";
  }
  if ($hour > 0) {
    if (strlen($out) > 0) $out .= ", ";
    $out .= $hour;
    $out .= " hour";
    if ($hour != 1) $out .= "s";
  }
  if ($minute > 0) {
    if (strlen($out) > 0) $out .= ", ";
    $out .= $minute;
    $out .= " minute";
    if ($minute != 1) $out .= "s";
  }
  if ($second > 0) {
    if (strlen($out) > 0) $out .= ", ";
    $out .= $second;
    $out .= " second";
    if ($second != 1) $out .= "s";
  }
  return $out;
}

function blenzaplus_htmlentities($in)
{
  //return htmlentities($in);
  $out = "";
  for ($i = 0; $i < strlen($in); $i++) {
    $ch = substr($in, $i, 1);
    $ord = ord($ch);
    $and1 = $ord & 0x80;
    $and2 = $ord & 0xc0;
    $and3 = $ord & 0xe0;
    $and4 = $ord & 0xf0;
    $and5 = $ord & 0xf8;
    $and6 = $ord & 0xfc;
    if ($and6 == 0xfc) {
      $b = 6;
      $ord1 = $ord & 0x1;
      $ord2 = ord(substr($in, ++$i, 1)) & 0x3f;
      $ord3 = ord(substr($in, ++$i, 1)) & 0x3f;
      $ord4 = ord(substr($in, ++$i, 1)) & 0x3f;
      $ord5 = ord(substr($in, ++$i, 1)) & 0x3f;
      $ord6 = ord(substr($in, ++$i, 1)) & 0x3f;
      $ord = $ord6 + ($ord5 << 6) + ($ord4 << 12) + ($ord3 << 18) + ($ord2 << 24) + ($ord1 << 30);
      $out .= "&#{$ord};";
    }
    else if ($and5 == 0xf8) {
      $b = 5;
      $ord1 = $ord & 0x3;
      $ord2 = ord(substr($in, ++$i, 1)) & 0x3f;
      $ord3 = ord(substr($in, ++$i, 1)) & 0x3f;
      $ord4 = ord(substr($in, ++$i, 1)) & 0x3f;
      $ord5 = ord(substr($in, ++$i, 1)) & 0x3f;
      $ord = $ord5 + ($ord4 << 6) + ($ord3 << 12) + ($ord2 << 18) + ($ord1 << 24);
      $out .= "&#{$ord};";
    }
    else if ($and4 == 0xf0) {
      $b = 4;
      $ord1 = $ord & 0x7;
      $ord2 = ord(substr($in, ++$i, 1)) & 0x3f;
      $ord3 = ord(substr($in, ++$i, 1)) & 0x3f;
      $ord4 = ord(substr($in, ++$i, 1)) & 0x3f;
      $ord = $ord4 + ($ord3 << 6) + ($ord2 << 12) + ($ord3 << 18);
      $out .= "&#{$ord};";
    }
    else if ($and3 == 0xe0) {
      $b = 3;
      $ord1 = $ord & 0xf;
      $ord2 = ord(substr($in, ++$i, 1)) & 0x3f;
      $ord3 = ord(substr($in, ++$i, 1)) & 0x3f;
      $ord = $ord3 + ($ord2 << 6) + ($ord1 << 12);
      $out .= "&#{$ord};";
    }
    else if ($and2 == 0xc0) {
      $b = 2;
      $ord1 = $ord & 0x1f;
      $ord2 = ord(substr($in, ++$i, 1)) & 0x3f;
      $ord = $ord2 + ($ord1 << 6);
      $out .= "&#{$ord};";
    }
    else {
      $b = 1;
      if ($ch == '&') $out .= $ch;
      else $out .= htmlentities($ch);
    }
  }
  return $out;
}

// perform link parse
function blenzaplus_checkLink($link)
{
  $parse = parse_url($link);
  if ($parse == false) return "Oops, the system didn't understand your link!";
  if (!array_key_exists("scheme", $parse)) return "Oops, your link is missing the 'http://' part!";
  if (!array_key_exists("scheme", $parse)) return "Oops, your link is missing the host part!";
  return $parse;
}

// perform link verification
function blenzaplus_connectLink($link)
{
  error_log("into verification with {$link}");
  $content = @file_get_contents($link);
  list($http, $status, $str) = explode(" ", $http_response_header[0], 3);
  if ($status == null) return "There was an error connecting to your link.";
  if ($status >= 400) return "There was a {$status} ({$str}) error connecting to your link.";
  return array("status" => $status, "content" => $content);
}

// perform content validation
function blenzaplus_validation($postid, $name, $host, $status, $content)
{
  // see if there is another link with this host
  if (blenzaplus_isOption("repeat")) {
    global $wpdb;

    $host4 = substr($host, 0, 4);
    if ($host4 == "www.") $host = substr($host, 4);

    $sql = $wpdb->prepare("select * from {$wpdb->prefix}blenzaplusLinks where post = %d and link like %s and name <> %s", $postid, "%{$host}%", $name);
    $links = $wpdb->get_results($sql);
    if (count($links) > 0) {
      $names = "";
      foreach ($links as $link) {
        $error2 = $link->error;
        if (strpos($error2, "Host {$host} found") === false) {
          if ($error2 != null) $error2 .= " ";
          $error2 .= "Host {$host} found in later post.";
          $sql2 = $wpdb->prepare("update {$wpdb->prefix}blenzaplusLinks set error = %s where post = %d and id = %d", $error2, $postid, $link->id);
          $res2 = $wpdb->query($sql2);
        }
        if ($names != "") $names .= ", ";
        $names .= $link->name;
      }
      $hostError = "Host {$host} found in posts by: {$names}.";
    }
    else $hostError = null;
  }
  else $hostError = null;

  // no other validation checking
  $valid = 1;

  // if we connected and got content and if we've got a widget and if
  // that widget has a validator... use WHILE purely for convenience.
  $vaderError = null;
  while ($content != null) {
    $metaStr = get_post_meta($postid, "blenzaplus_meta", true);
    if (strlen($metaStr) == 0) break;

    $meta = unserialize($metaStr);
    if ($meta["widget"] == null) break;

    $widget = blenzaplus_getWidget($meta["widget"]);
    if ($widget == null) break;
    if ($widget->validator == null) break;

    $delim = blenzaplus_getPregDelim($widget->validator);
    if ($delim == null) {
      $vaderError = "Internal validator error";
      break;
    }

    $n = preg_match("${delim}{$widget->validator}${delim}is", $content);
    if ($n == 0) {
      $vaderError = "Validator missing";
      break;
    }

    // we're done.
    break;
  }

  // sum up the errors
  $error = "";
  if ($hostError) {
    if ($error) $error .= " ";
    $error .= $hostError;
  }

  if ($status >= 400) {
    if ($error) $error .= " ";
    $error .= "HTTP status: {$status}.";
  }

  if ($vaderError !== null) {
    if ($error) $error .= " ";
    $error .= "{$vaderError}.";
  }

  return $error;
}

// helper to insert a new link, whether it came from entry for or comment
function blenzaplus_insertLink($postid, $name, $link, $extra,
  $ipaddr = null, $secret = -1, $approved = 0, $error = null)
{
  // validation was already done during comment processing, but let's
  // see if this exact link is already in the database
  global $wpdb;
  $sql = $wpdb->prepare("select * from {$wpdb->prefix}blenzaplusLinks where post = %d and name = %s and link = %s", $postid, $name, $link);
  $links = $wpdb->get_results($sql);
  if (count($links) > 0) {
    $sql = $wpdb->prepare("update {$wpdb->prefix}blenzaplusLinks set secret = %d, approved = %d where post = %d and id = %d", $secret, $approved, $postid, $links[0]->id);
    $res = $wpdb->query($sql);
    if ($res === false) return null;
    return $links[0]->id;
  }

  // add all of this information to the links table.
  global $wpdb;
  $row = array
    (
     "post" => $postid,
     "name" => $name,
     "link" => $link,
     "extra" => $extra,
     "ipaddr" => $ipaddr,
     "secret" => $secret,
     "approved" => $approved,
     "error" => $error,
     "time" => time()
     );

  $wpdb->insert("{$wpdb->prefix}blenzaplusLinks", $row);

  // figure out the id if we didn't get one back
  $id = $wpdb->insert_id;
  if ($id == null) {
    ob_start();
    $wpdb->print_error();
    error_log("sql error: " . ob_get_contents());
    ob_end_clean();
  }

  // and return what we've just created.
  return $id;
}

// create a thumbnail file
function blenzaplus_createThumbnail($n, $id, $op, $image)
{
  error_log("createThumbnail: n: " . $n . ", id: " . $id . ", op: " . $op . ", image: " . $image);

  $thint = get_option("blenzaplus_thumbInt");
  $internal = "{$thint}/thumb-{$id}.png";

  $type = null;
  $thumbName = "(Name unknown)";

  if ($op == "file") {
    $size = floor(filesize($file["tmp_name"]) /1024);

    if ($size > 1024) sendXML("Image file too large: {$size} KB");

    $thumbName = $file["tmp_name"];

    list($uw, $uh) = getimagesize($file["tmp_name"]);

    if ($file["type"] == "image/jpeg") {
      $upload = imagecreatefromjpeg($file["tmp_name"]);
      $type = "jpeg";
    }
    else if ($file["type"] == "image/pjpeg") {
      $upload = imagecreatefromjpeg($file["tmp_name"]);
      $type = "jpeg";
    }
    else if ($file["type"] == "image/gif") {
      $upload = imagecreatefromgif($file["tmp_name"]);
      $type = "gif";
    }
    else if ($file["type"] == "image/png") {
      $upload = imagecreatefrompng($file["tmp_name"]);
      $type = "png";
    }
    else if ($file["type"] == "image/bmp") {
      $upload = imagecreatefrombmp($file["tmp_name"]);
      $type = "bmp";
    }
    else if ($file["type"] == "application/octet-stream") {
      $dot = strrpos($file["name"], ".");
      $ext = strtolower(substr($file["name"], $dot));
      if ($ext == ".jpg") {
        $upload = imagecreatefromjpeg($file["tmp_name"]);
        $type = "jpeg";
      }
      else if ($ext == ".gif") {
        $upload = imagecreatefromgif($file["tmp_name"]);
        $type = "gif";
      }
      else if ($ext == ".png") {
        $upload = imagecreatefrompng($file["tmp_name"]);
        $type = "png";
      }
      else if ($ext == ".bmp") {
        $upload = imagecreatefrombmp($file["tmp_name"]);
        $type = "bmp";
      }
      else {
        sendXML("%FILETYPE/$ext");
      }
    }
    else sendXML("%FILETYPE/{$file["type"]}");
  }

  else if (($op == "site") || ($op == "url") || ($op == "gravatar")) {
    $thumbName = $image;

    $dot = strrpos($image, ".");
    $ext = strtolower(substr($image, $dot));

    $imageTemp = $internal . ".TMP";
    $getimg = file_get_contents($image);
    if ($getimg == null) sendXML("Could not retrieve image content.");
    $tmp = fopen($imageTemp, "w");
    if (!$tmp) sendXML("Could not create temporary file.");
    fwrite($tmp, $getimg);
    fclose($tmp);

    list($uw, $uh) = getimagesize($imageTemp);

    if ($ext == ".jpg") {
      $upload = imagecreatefromjpeg($imageTemp);
      $type = "jpeg";
    }
    else if ($ext == ".gif") {
      $upload = imagecreatefromgif($imageTemp);
      $type = "gif";
    }
    else if ($ext == ".png") {
      $upload = imagecreatefrompng($imageTemp);
      $type = "png";
    }
    else if ($ext == ".bmp") {
      $upload = imagecreatefrombmp($imageTemp);
      $type = "bmp";
    }
    else {
      sendXML("%FILETYPE/{$ext}");
    }
  }

  // if the image is pretty much square, just resize; otherwise crop
  $min = min($uw, $uh);
  $max = max($uw, $uh);
  $div = floor(100 * $min/$max);

  if ($div < 95) {
    //sendXML("Image not square enough ({$uw} x {$uh}: {$div}%)");
    if ($uw > $uh) {
      $uy = 0;
      $ux = floor(($uw-$uh) / 2);
      $uw = $uh;
    }
    else {
      $ux = 0;
      $uy = floor(($uh-$uw) / 2);
      $uh = $uw;
    }
  }
  else {
    $ux = 0;
    $uy = 0;
  }

  // resized image will be fixed 75x75
  $rw = 75;
  $rh = 75;

  // create a new image object and crop/resize into it
  $resized = imagecreatetruecolor($rw, $rh);

  $sts = imagecopyresized
    ($resized, $upload, 0, 0, $ux, $uy, $rw, $rh, $uw, $uh);
  if (!$sts) sendXML("Error resizing image");

  // write the file and clean up
  imagepng($resized, $internal);
  imagedestroy($resized);
  imagedestroy($upload);
  @unlink($imageTemp);
}

// convert an external widget by connecting to the server, retrieving
// event/link information, and adding it to our metadata/database
function blenzaplus_convertExternalWidget($postid)
{
  // get our post metadata
  $metaStr = get_post_meta($postid, "blenzaplus_meta", true);
  if (strlen($metaStr) == 0) $meta = array();
  else $meta = unserialize($metaStr);

  // if we've noted in our metadata that the external widget has
  // already been converted, don't do this step again
  if ($meta["converted"]) return;

  // get the external widget's content from the remote server
  $remote = file_get_contents($meta["extLink"]);

  // parsing is different for different servers, of course...
  if ($meta["extServer"] == "Blenza") {
    $lines = explode("\n", $remote);
    $remeta = array();
    $count = 0;
    $nlink = -1;
    foreach ($lines as $n => $line) {
      list($name, $value) = explode(":", $line);
      if ($name == "Count") {
        $remeta[$name] = $value;
        $count = $value;
        $nlink = $n;
        break;
      }
      else if (strlen($value) > 0) {
        $remeta[$name] = base64_decode($value);
      }
    }
    if (strlen($remeta["Meme Name"]) > 0) {
      $widget = blenzaplus_findWidget($remeta["Meme Name"]);
      if ($widget === null) {
        $widget = blenzaplus_insertWidget($remeta["Meme Name"], $remeta["Meme Text"]);
      }
      $meta["widget"] = $widget;
    }
    $nlink++;
    for ($i = $nlink; $i < $nlink + 3*$count; $i+=3) {
      list($name0, $value0) = explode(":", $lines[$i]);
      list($name1, $value1) = explode(":", $lines[$i+1]);
      list($name2, $value2) = explode(":", $lines[$i+2]);
      if (($name0 != "Name")||($name1 != "URL")||($name2 != "ID")) continue;
      $name = base64_decode($value0);
      $link = base64_decode($value1);
      blenzaplus_insertLink($postid, $name, $link, null);
    }
  }

  else if ($meta["extServer"] == "Linkytools") {
    $links = blenzaplus_convertLinkytools($remote);
    foreach ($links as $link) {
      blenzaplus_insertLink($postid, $link["name"], $link["link"], null);
    }
  }

  else if ($meta["extServer"] == "Simply-Linked") {
    $links = blenzaplus_convertSimplylinked($remote);
    foreach ($links as $link) {
      blenzaplus_insertLink($postid, $link["name"], $link["link"], null);
    }
  }

  else die("No parser for widget.");

  $meta["converted"] = true;

  // add or update the metadata for this post.
  blenzaplus_updateMetadata($postid, $meta);
}

// examine a Linkytools widget and extract the links from it
function blenzaplus_convertLinkytools($str)
{
  global $blenzaplus_externalPat1;
  $pat = "~{$blenzaplus_externalPat1}~";
  $mats = array();
  $mc = preg_match_all($pat, $str, $mats);
  $links = array();
  for ($i = 0; $i < $mc; $i++) {
    $links[$i] = array("name" => $mats[2][$i], "link" => $mats[1][$i]);
  }
  return $links;
}

// examine a Linkytools widget and extract the links from it
function blenzaplus_convertSimplylinked($str)
{
  global $blenzaplus_externalPat2;
  $pat = "~{$blenzaplus_externalPat2}~";
  $mats = array();
  $mc = preg_match_all($pat, $str, $mats);
  $links = array();
  for ($i = 0; $i < $mc; $i++) {
    $links[$i] = array("name" => $mats[2][$i], "link" => $mats[1][$i]);
  }
  return $links;
}

// helper function to add or update the metadata for this post.
function blenzaplus_updateMetadata($postid, $meta)
{
  // see if we already had metadata
  $metaStr = get_post_meta($postid, "blenzaplus_meta", true);
  update_post_meta($postid, "blenzaplus_meta", serialize($meta));
}

// helper function to get us the request input, stripped
function blenzaplus_stripRequest($name)
{
  if (!array_key_exists($name, $_REQUEST)) return null;
  return stripslashes( preg_replace( "/(\%u)([0-9A-F][0-9A-F][0-9A-F][0-9A-F])/", "&#x\\2;", $_REQUEST [$name] ) );
}

// help function to get us a session attribute, stripped
function blenzaplus_stripSession($name)
{
  if (!array_key_exists($name, $_SESSION)) return null;
  return stripslashes( preg_replace( "/(\%u)([0-9A-F][0-9A-F][0-9A-F][0-9A-F])/", "&#x\\2;", $_SESSION [$name] ) );
}

// is the option really on or not?
function blenzaplus_isOption($name)
{
  $val = get_option("blenzaplus_{$name}");
  if ($val == null) return false;
  if (($val == "yes") || ($val == 1)) return true;
  if (($val == "no") || ($val == 0)) return false;
  return $val;
}

// finish converting an external widget by removing the code from the
// post and enabling our linky widget we created to replace it.
function blenzaplus_finishExternalWidget($postid)
{
  global $blenzaplus_mlwp;

  // get our post metadata
  $metaStr = get_post_meta($postid, "blenzaplus_meta", true);
  if (strlen($metaStr) == 0) $meta = array();
  else $meta = unserialize($metaStr);

  // get the post and the external widget code from it
  $post = get_post($postid);
  $extCode = blenzaplus_externalWidgetCode($post->post_content);
  $code = $extCode[0];

  // make sure the external widget code is what we thought.
  if ($code != $meta["externalCode"]) die("Inconsistent externalCode value.");

  if ($extCode[0] == $blenzaplus_mlwp) {
    update_post_meta($postid, "post_meme", -1);
  }

  else {
    $pos = strpos($post->post_content, $code);
    if ($pos === false) die("Code in post not found in post.");

    // get the stuff before the code
    $new1 = substr($post->post_content, 0, $pos);

    // and get the stuff after the code, trimming away any white space
    // that was between the code and what was after it.
    $new2 = ltrim(substr($post->post_content, $pos + strlen($code)));

    // update the content in the post object
    $post->post_content = $new1 . $new2;

    // update the post in the database
    wp_update_post($post);
  }

  // and enable the new widget.
  $meta["enabled"] = true;

  // now that we've removed the script, if they put it back, they can
  // perform the conversion again, hopefully after deleting the links.
  $meta["converted"] = false;

  // add or update the metadata for this post.
  blenzaplus_updateMetadata($postid, $meta);
}

// update check
function blenzaplus_processUpdate($update)
{
  if (is_bool($update)) {
    return $update;
  }
  else if ($update === null) {
    error_log("Processing null update");
    die;
  }
  if (!is_array($update)) {
    error_log("Processing scalar update: {$update}");
    die;
  }

  $errFound = false;

  // set the values we got back from the udpate server.
  foreach ($update as $key => $val) {
    update_option("blenzaplus_{$key}", $val);
    if ($key == "error") $errFound = true;
  }

  if ($errFound) return false;
  else delete_option("blenzaplus_error");

  // and remember we did this.
  update_option("blenzaplus_checked", time());

  // and we're good.
  return true;
}

// status check
function blenzaplus_checkStatus()
{
  // see if the update has been set up.
  $update = blenzaplus_checkUpdate();
  $status = blenzaplus_processUpdate($update);
  if (!$status) return $status;
  $expiry = get_option("blenzaplus_expiry");
  if (($expiry != -1) && ($expiry + 1209600 < time())) return null;
  return true;
}
?>
