<?php
// target/nofollow link attributes are global options
$target = get_option("blenzaplus_target");
if ($target == null) $target = "yes";
$nofollow = get_option("blenzaplus_nofollow");
if ($nofollow == null) $nofollow = "yes";

// the widget color and width are global options
list($colorsStr, $colors) = blenzaplus_getColors();
list($widthStr, $width) = blenzaplus_getWidth();
list($fontStr, $font) = blenzaplus_getFontFamily();
list($fsizeStr, $fsize) = blenzaplus_getFontSize();

// number of columns may be set per-widget
$columns = $meta["columns"];
if ($columns == null) $columns = get_option("blenzaplus_columns");
if ($columns == null) $columns = 3;

// are we using the checkbox or name/link form? (global)
$comments = get_option("blenzaplus_comments");
if ($comments == null) $comments = "yes";

// extra-box may be set per-widget
$extra = $meta["extra"];
if ($extra == null) $extra = get_option("blenzaplus_extra");
if ($extra == null) $extra = "no";
$exdesc = $meta["exdesc"];
$exshow = $meta["exshow"];

// see if thumbnails are even configured
$thumbsOn = (get_option("blenzaplus_thumbs") == "yes");

if ($thumbsOn) {
  // thumbnails may be set per-widget
  $thumbs = $meta["thumbs"];
  if ($thumbs == null) $thumbs = get_option("blenzaplus_thumbs");
  if ($thumbs == null) $thumbs = "no";
  $threqd = $meta["threqd"];
  $thaprv = $meta["thaprv"];
}
else {
  $thumbs = null;
  $threqd = null;
  $thaprv = null;
}

// has the donation box been checked?  if so, thank you!!
$donated = get_option("blenzaplus_donated");

// have we started and/or ended this widget?
$starts = $meta["starts"];
if (($starts == null) || ($starts == "started")) $started = true;
else if ($starts == "specify") $started = ($meta["startsat"] <= $now);
else $started = false;

$ends = $meta["ends"];
if (($ends == null) || ($ends == "never")) $ended = false;
else if ($ends == "specify") $ended = ($meta["endsat"] <= $now);
else if ($ends == "after") $ended = ($meta["endsat"] <= $now);
else $ended = true;

$widget = blenzaplus_getWidget($meta["widget"]);

$id = $widget->id;
$title = $widget->name;
$description = $widget->description;
$validator = $widget->validator;
?>