<?php
// include bits of wordpress so we can use the database, etc.
include "wordpress.php";

// check for valid data
$n = blenzaplus_stripRequest('n');
if ($n === null) sendXML("Missing post id");
if (!is_numeric($n)) sendXML("Illegal post id");

$op = blenzaplus_stripRequest('op');
if ($op == null) sendXML("Missing op.");

$id = blenzaplus_stripRequest('id');
if ($id === null) sendXML("Missing link id");
if (!is_numeric($id)) sendXML("Illegal link id");

$secret = blenzaplus_stripRequest('secret');
if ($secret === null) sendXML("Missing secret");
if (!is_numeric($secret)) sendXML("Illegal secret");

// make sure the secret matches.
$link = $wpdb->get_row($wpdb->prepare("select * from {$wpdb->prefix}blenzaplusLinks where id = %d and post = %d and secret = %d", $id, $n, $secret));
if ($link == null) sendXML("Could not find link");

$thint = get_option("blenzaplus_thumbInt");
if ($thint == null) sendXML("Thumbnails configuration is incomplete");
$internal = "{$thint}/thumb-{$id}.png";

$type = null;
$thumbName = "(Name unknown)";

if ($op == "file") {
  $file = $_FILES["image"];
  if ($file === null) sendXML("Missing image.");
  if ($file["name"] == null) sendXML("Missing image.");
  if ($file["type"] == null) sendXML("Missing image.");
  if ($file["size"] == null) sendXML("Missing image.");

  if (!is_uploaded_file($file["tmp_name"])) sendXML("Illegal upload");

  $size = floor(filesize($file["tmp_name"]) /1024);

  if ($size > 1024) sendXML("Image file too large: {$size} KB");

  $thumbName = $file["tmp_name"];

  list($uw, $uh) = getimagesize($file["tmp_name"]);

  if ($file["type"] == "image/jpeg") {
    $upload = imagecreatefromjpeg($file["tmp_name"]);
    $type = "jpeg";
  }
  else if ($file["type"] == "image/pjpeg") {
    $upload = imagecreatefromjpeg($file["tmp_name"]);
    $type = "jpeg";
  }
  else if ($file["type"] == "image/gif") {
    $upload = imagecreatefromgif($file["tmp_name"]);
    $type = "gif";
  }
  else if ($file["type"] == "image/png") {
    $upload = imagecreatefrompng($file["tmp_name"]);
    $type = "png";
  }
  else if ($file["type"] == "image/bmp") {
    $upload = imagecreatefrombmp($file["tmp_name"]);
    $type = "bmp";
  }
  else if ($file["type"] == "application/octet-stream") {
    $dot = strrpos($file["name"], ".");
    $ext = strtolower(substr($file["name"], $dot));
    if ($ext == ".jpg") {
      $upload = imagecreatefromjpeg($file["tmp_name"]);
      $type = "jpeg";
    }
    else if ($ext == ".gif") {
      $upload = imagecreatefromgif($file["tmp_name"]);
      $type = "gif";
    }
    else if ($ext == ".png") {
      $upload = imagecreatefrompng($file["tmp_name"]);
      $type = "png";
    }
    else if ($ext == ".bmp") {
      $upload = imagecreatefrombmp($file["tmp_name"]);
      $type = "bmp";
    }
    else {
      sendXML("%FILETYPE/$ext");
    }
  }
  else sendXML("%FILETYPE/{$file["type"]}");
}

else if (($op == "site") || ($op == "url") || ($op == "gravatar")) {
  if ($op == "site") {
    $image = blenzaplus_stripRequest("imageSite");
    if ($image == null) sendXML("Please click an image.");
  }
  else if ($op == "url") {
    $image = blenzaplus_stripRequest("imageURL");
    if ($image == null) sendXML("Please enter the URL of an image.");
  }
  else if ($op == "gravatar") {
    $image = "http://www.gravatar.com/avatar/"
      . md5(strtolower(trim(blenzaplus_stripRequest("emailAddress"))))
      . "?s=75.jpg";
  }

  $thumbName = $image;

  $dot = strrpos($image, ".");
  $ext = strtolower(substr($image, $dot));

  $imageTemp = $internal . ".TMP";
  $getimg = file_get_contents($image);
  if ($getimg == null) sendXML("Could not retrieve image content.");
  $tmp = fopen($imageTemp, "w");
  if (!$tmp) sendXML("Could not create temporary file.");
  fwrite($tmp, $getimg);
  fclose($tmp);

  list($uw, $uh) = getimagesize($imageTemp);

  if ($ext == ".jpg") {
    $upload = imagecreatefromjpeg($imageTemp);
    $type = "jpeg";
  }
  else if ($ext == ".gif") {
    $upload = imagecreatefromgif($imageTemp);
    $type = "gif";
  }
  else if ($ext == ".png") {
    $upload = imagecreatefrompng($imageTemp);
    $type = "png";
  }
  else if ($ext == ".bmp") {
    $upload = imagecreatefrombmp($imageTemp);
    $type = "bmp";
  }
  else {
    sendXML("%FILETYPE/{$ext}");
  }
}

// if the image is pretty much square, just resize; otherwise crop
$min = min($uw, $uh);
$max = max($uw, $uh);
$div = floor(100 * $min/$max);

if ($div < 95) {
  //sendXML("Image not square enough ({$uw} x {$uh}: {$div}%)");
  if ($uw > $uh) {
    $uy = 0;
    $ux = floor(($uw-$uh) / 2);
    $uw = $uh;
  }
  else {
    $ux = 0;
    $uy = floor(($uh-$uw) / 2);
    $uh = $uw;
  }
}
else {
  $ux = 0;
  $uy = 0;
}

// resized image will be fixed 75x75
$rw = 75;
$rh = 75;

// create a new image object and crop/resize into it
$resized = imagecreatetruecolor($rw, $rh);

$sts = imagecopyresized
  ($resized, $upload, 0, 0, $ux, $uy, $rw, $rh, $uw, $uh);
if (!$sts) sendXML("Error resizing image");

// we're about to write the file. set this entry to unapproved.
$res = $wpdb->query($wpdb->prepare("update {$wpdb->prefix}blenzaplusLinks set approved = -1 where id = %d and post = %d and secret = %d", $id, $n, $secret));

// write the file and clean up
imagepng($resized, $internal);
imagedestroy($resized);
imagedestroy($upload);
@unlink($imageTemp);

sendXML();

function sendXML($msg = null)
{
  header("Content-type: text/xml");
  echo "<?xml version=\"1.0\"?>\n";
  echo "<blenzaplus>\n";
  if (substr($msg, 0, 1) == "%") echo "<status>{$msg}</status>\n";
  else if ($msg !== null) echo "<error>{$msg}</error>\n";
  else echo "<status>OK</status>\n";
  echo "</blenzaplus>\n";
  die;
}
?>