<?php
// include bits of wordpress so we can use the database, etc.
include "wordpress.php";

$n = blenzaplus_stripRequest("n");
$name = blenzaplus_stripRequest("name");
$link = blenzaplus_stripRequest("link");
$extra = blenzaplus_stripRequest("extra");
$ipaddr = blenzaplus_stripRequest("ipaddr");

$op = blenzaplus_stripRequest('op');
$image = blenzaplus_stripRequest('image');

// check for valid data
if ($n === null) sendXML("Missing post id");
if (!is_numeric($n)) sendXML("Illegal post id");

// get our post metadata
$metaStr = get_post_meta($n, "blenzaplus_meta", true);
if (strlen($metaStr) == 0) $meta = array();
else $meta = unserialize($metaStr);

// check the link, non-array means error
$parse = blenzaplus_checkLink($link);
if (!is_array($parse)) sendXML($parse);

if (blenzaplus_isOption("connect")) {
  // check the connection, non-array means error
  $site = blenzaplus_connectLink($link);
  if (!is_array($site)) sendXML($site);
  error_log("status came back {$site["status"]}");
  error_log("content (len) came back ".strlen($site["content"]));
}

// perform the content validation and error checking.
$host = $parse["host"];
$error = blenzaplus_validation($n, $name, $host, $site["status"], $site["content"]);

// think up a secret random number to share with the thumbnail code
$secret = rand();

// if there is an image, approval is negative; if not just nothing.
$approved = ($op) ? -1 : 0;

// if a thumbnail is required, now is the time to alert the user.
if ((!$op) && ($meta["thumbs"] == "yes") && ($meta["threqd"] == "yes")) sendXML("%THUMBREQ");

// insert it into the database.
$linkid = blenzaplus_insertLink($n, $name, $link, $extra, $ipaddr, $secret, $approved, $error);

// if there's no thumbnail, we're done.
if ($op) {
  // we don't have md5 in javascript, so if we're using a gravatar, do that now.
  if ($op == "gravatar") {
    $image = "http://www.gravatar.com/avatar/"
      . md5(strtolower(trim($image)))
      . "?default=404&s=75.jpg";
  }

  // and create the thumbnail to go with it.
  blenzaplus_createThumbnail($postid, $linkid, $op, $image);
}

sendXML(null, $secret, $linkid);

function sendXML($msg = null, $secret = null, $id = null)
{
  header("Content-type: text/xml");
  echo "<?xml version=\"1.0\"?>\n";
  echo "<blenzaplus>\n";
  if (substr($msg, 0, 1) == "%") echo "<status>{$msg}</status>\n";
  else if ($msg !== null) echo "<error>{$msg}</error>\n";
  else echo "<status>OK</status>\n";
  if ($secret) echo "<secret>{$secret}</secret>\n";
  if ($id) echo "<id>{$id}</id>\n";
  echo "</blenzaplus>\n";
  die;
}
?>