<script type="text/javascript">
// capture the local and server time for comparison
var blenzaplus_timeShift = new Date().getTime() - <?php echo $now * 1000; ?>;

<?php if ($checked == "checked") { ?>
document.getElementById("blenzaplus_widget").style.display = "block";
<?php } ?>

// let the user know when the dates are in the past
blenzaplus_checkDates();

// if the user wants an extra box they can enter a description.
blenzaplus_checkExtra();

// if the user wants thumbnails they can enter an image to process.
blenzaplus_checkThumbs();

// see if we're starting the conversion process
<?php if ($convertPhase != null) { ?>
blenzaplus_convertExternalPhase(<?php echo blenzaplus_postId().','.$convertPhase; ?>);
<?php } ?>

// hide or show the widget details
function blenzaplus_toggleWidget()
{
  var cb = document.getElementById("blenzaplus_enableWidget");
  var div = document.getElementById("blenzaplus_widget");
  var delp = document.getElementById("blenzaplus_widgetDelp");
  if (cb.checked) {
    div.style.display = "block";
    /* if (delp != null) */ delp.style.display = "none";
  }
  else {
    div.style.display = "none";
    /* if (delp != null) */ delp.style.display = "block";
  }
}

// create a widget, part 1: toggle form
function blenzaplus_select(n)
{
  if (n == null) n = "";
  var rads = document.getElementsByName("blenzaplus_selectWidget");
  for (var i = 0; i < rads.length; i++) {
    if (rads[i].value == n) rads[i].checked = true;
    else rads[i].checked = false;
  }
  var div = document.getElementById("blenzaplus_widgetCreate");
  div.style.display = "none";
}

function blenzaplus_doCreate()
{
  var radioNew = null;
  var rads = document.getElementsByName("blenzaplus_selectWidget");
  for (var i = 0; i < rads.length; i++) {
    if (rads[i].value == "NEW") radioNew = rads[i];
    else {
      var n = rads[i].parentNode.parentNode.getAttribute('number');
      var div = document.getElementById("blenzaplus_widgetEdit" + n);
      if (div) div.style.display = "none";
    }
  }
  var div = document.getElementById("blenzaplus_widgetCreate");
  if (radioNew.checked) div.style.display = "block";
  else if (div.style.display == "block") div.style.display = "none";
  else {
    div.style.display = "block";
    radioNew.checked = true;
  }
}

// cancel the create
function blenzaplus_doCreateCancel()
{
  var radioPlain = null;
  var radioDefault = null;
  var radioNew = null;
  var rads = document.getElementsByName("blenzaplus_selectWidget");
  for (var i = 0; i < rads.length; i++) {
    if (rads[i].value == "NEW") radioNew = rads[i];
    if (rads[i].value == "") radioPlain = rads[i];
    if (rads[i].value == "<?php echo $meta["widget"]; ?>") radioDefault = rads[i];
  }
  radioNew.checked = false;
  if (radioDefault != null) radioDefault.checked = true;
  else radioPlain.checked = true;
  blenzaplus_doCreate();
}

// finish the create
function blenzaplus_doCreateInsert()
{
  // validate the inputs first
  var inp = document.getElementById("blenzaplus_newWidgetName");
  var name = inp.value;
  if (inp.value == "<?php echo $blenzaplus_newHintName; ?>") {
    return alert("<?php echo $blenzaplus_missingName; ?>");
  }

  // get the description from the create form and reset it for next use
  var inp = document.getElementById("blenzaplus_newWidgetDesc");
  var desc = inp.value;
  if (inp.value == "<?php echo $blenzaplus_newHintDesc; ?>") {
    return alert("<?php echo $blenzaplus_missingDesc; ?>");
  }

  <?php if (blenzaplus_isOption("connect")) { ?>
  // get the validator from the create form and reset it for next use
  var inp = document.getElementById("blenzaplus_newWidgetVader");
  var vader = inp.value;
  if (inp.value == "<?php echo $blenzaplus_newHintVader; ?>") {
    //return alert("<?php echo $blenzaplus_missingVader; ?>");
    vader = null;
  }
  <?php } ?>

  // get the name from the create form and reset it for next use
  var inp = document.getElementById("blenzaplus_newWidgetName");
  var name = inp.value;
  inp.value = "<?php echo $blenzaplus_newHintName; ?>";

  // get the description from the create form and reset it for next use
  var inp = document.getElementById("blenzaplus_newWidgetDesc");
  var desc = inp.value;
  inp.value = "<?php echo $blenzaplus_newHintDesc; ?>";

  <?php if (blenzaplus_isOption("connect")) { ?>
  // get the validator from the create form and reset it for next use
  var inp = document.getElementById("blenzaplus_newWidgetVader");
  var vader = inp.value;
  inp.value = "<?php echo $blenzaplus_newHintVader; ?>";
  <?php } else { ?>
  var vader = null;
  <?php } ?>

  // construct the data part from the name and description
  var data = "name=" + escape(name) + "&desc=" + escape(desc);
  if (vader != null) data += "&vader=" + escape(vader);

  // send the request to do the work
  var ret = blenzaplus_doAction("widget", "create", null, data);

  // pick out the number of the new widget.
  var n = ret["id"];

  // create a new span and clone the template into it
  var temp = document.getElementById("blenzaplus_widgetTemplate");
  var span = document.createElement("span");
  span.innerHTML = temp.innerHTML;

  // set its number attribute so all of the functions work on it.
  span.setAttribute("number", n);

  // set up the container for everything about the widget
  var els = span.getElementsByTagName("p")
  var el = els[0];
  el.id = "blenzaplus_widgetCon" + n;

  // set up this widget's radio button.
  var els = span.getElementsByTagName("input")
  var el = els[0];
  el.checked = true;
  el.value = n;

  // set the name of the widget
  var els = span.getElementsByTagName("span")
  var el = els[0];
  el.innerHTML = name;

  // set up the container for editing
  var els = span.getElementsByTagName("div")
  var el = els[0];
  el.id = "blenzaplus_widgetEdit" + n;

  // set up the name field in the edit form
  var els = span.getElementsByTagName("input")
  var el = els[1];
  el.id = "blenzaplus_editWidgetName" + n;
  el.value = name;

  // set up the description field in the edit form
  var els = span.getElementsByTagName("textarea")
  var el = els[0];
  el.id = "blenzaplus_editWidgetDesc" + n;
  el.value = desc;

  <?php if (blenzaplus_isOption("connect")) { ?>
  // set up the validator field in the edit form
  var els = span.getElementsByTagName("input")
  var el = els[2];
  el.id = "blenzaplus_editWidgetVader" + n;
  el.value = vader;
  <?php } ?>

  // insert this into the list of widgets
  var radio = document.getElementById("blenzaplus_selectWidgetNew");
  radio.parentNode.insertBefore(span, radio);

  // and hide the create form
  var div = document.getElementById("blenzaplus_widgetCreate");
  div.style.display = "none";
}

// delete a widget
function blenzaplus_doDelete(n)
{
  if (!confirm('Are you sure you wish to delete this widget?')) return;
  blenzaplus_doAction("widget", "delete", n, null);
  var par = document.getElementById("blenzaplus_widgetCon" + n);
  if (par == null) return alert("INTERNAL ERROR, No container for " + n);
  par.style.display = "none";
}

// edit a widget, part 1: toggle form
function blenzaplus_doEdit(n)
{
  /*
  var div = document.getElementById("blenzaplus_widgetCreate");
  div.style.display = "none";
  */
  blenzaplus_select(n);
  var div = document.getElementById("blenzaplus_widgetEdit" + n);
  if (div == null) return alert("INTERNAL ERROR, No div for " + n);
  if (div.style.display == "block") div.style.display = "none";
  else div.style.display = "block";
}

// edit a widget, part 2: perform the update
function blenzaplus_doEditUpdate(n)
{
  // get the values from the form
  var inp = document.getElementById("blenzaplus_editWidgetName" + n);
  if (inp == null) return alert("INTERNAL ERROR, No name for " + n);
  var name = inp.value;

  var inp = document.getElementById("blenzaplus_editWidgetDesc" + n);
  if (inp == null) return alert("INTERNAL ERROR, No description for " + n);
  var desc = inp.value;

  <?php if (blenzaplus_isOption("connect")) { ?>
  var inp = document.getElementById("blenzaplus_editWidgetVader" + n);
  if (inp == null) return alert("INTERNAL ERROR, No validator for " + n);
  var vader = inp.value;
  <?php } else { ?>
  var vader = null;
  <?php } ?>

  // construct the data part
  var data = "name=" + escape(name) + "&desc=" + escape(desc);
  if (vader != null) data += "&vader=" + escape(vader);

  // send the request to do the work
  blenzaplus_doAction("widget", "update", n, data);

  // finally close the form.
  blenzaplus_doEdit(n);
}

// delete all links for a widget
function blenzaplus_doDeleteAll(postid)
{
  if (postid == null) return;
  blenzaplus_deleteAllLinks(postid);
}

// function for performing any request we need
function blenzaplus_doAction(ty, op, id, data)
{
  var req = null;
  var tyRet = null;
  var opRet = null;
  var idRet = null;
  var stRet = null;

  try {
    // send the request to the server.
    req = blenzaplus_xmlRequest();
    var url = "<?php echo $blenzaplus_homeUrl; ?>/action.php?ty=" + ty + "&op=" + op;
    if (id != null) url += "&id=" + id;
    req.open((data == null) ? "GET" : "POST", url, false);
    req.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
    req.send(data);

    // handle unexpected problems
    if (req.readyState != 4) throw "State " + req.readyState;
    if (req.status != 200) throw "Status " + req.status;
    if (req.responseXML == null) throw "No XML returned";

    // handle expected return data
    var data = req.responseXML.getElementsByTagName("blenzaplus");
    if ((data == null) || (data.length != 1)) throw "No data returned";

    // parse the data that did come back.
    var tyTag = data[0].getElementsByTagName("ty");
    if ((tyTag == null) || (tyTag.length != 1)) throw "No type returned";
    tyRet = tyTag[0].firstChild.data;
    var opTag = data[0].getElementsByTagName("op");
    if ((opTag == null) || (opTag.length != 1)) throw "No opcode returned";
    opRet = opTag[0].firstChild.data;
    var idTag = data[0].getElementsByTagName("id");
    if ((idTag == null) || (idTag.length != 1)) throw "No id returned";
    idRet = idTag[0].firstChild.data;
    var stTag = data[0].getElementsByTagName("status");
    if ((stTag == null) || (stTag.length != 1)) throw "No status returned";
    stRet = stTag[0].firstChild.data;

    // make sure the operation succeeded
    if ((tyRet != ty) || (opRet != op)) throw "Internal error";
    if ((id != null) && (idRet != id)) throw "Internal error";
    if (stRet != 1) throw "The " + op + " action could not be performed";

    ret = new Array();
    ret["ty"] = tyRet;
    ret["op"] = opRet;
    ret["id"] = idRet;
    ret["st"] = stRet;
    return ret;
  }
  catch (e) {
    var msg = "An error occurred processing the request.\n\n" + e;
    if (url) msg += "\n\nURL: " + url;
    if (req.responseText) msg += "\n\n" + req.responseText;
    msg += "\n\nIf you would be so kind as to email this error text (or screen capture) to mister.linky@gmail.com it will be addressed as soon as possible.";
    alert(msg);
    return null;
  }
}

// when we focus on the name, if we haven't edited it, select it all
function blenzaplus_focusNew(inp)
{
  /*
  var rads = document.getElementsByName("blenzaplus_selectWidget");
  for (var i = 0; i < rads.length; i++) {
    if (rads[i].value == "NEW") rads[i].checked = true;
    else rads[i].checked = false;
  }
  */
  //var inp = document.getElementById("blenzaplus_newWidgetName");
  if (inp.value == "<?php echo $blenzaplus_newHintName; ?>") {
    inp.select();
  }
}

// when we focus on the description, if we haven't edited it, select it all
function blenzaplus_focusDesc(inp)
{
  /*
  var rads = document.getElementsByName("blenzaplus_selectWidget");
  for (var i = 0; i < rads.length; i++) {
    if (rads[i].value == "NEW") rads[i].checked = true;
    else rads[i].checked = false;
  }
  */
  //var inp = document.getElementById("blenzaplus_newWidgetDesc");
  if (inp.value == "<?php echo $blenzaplus_newHintDesc; ?>") {
    inp.select();
  }
}

<?php if (blenzaplus_isOption("connect")) { ?>
// when we focus on the validator, if we haven't edited it, select it all
function blenzaplus_focusVader(inp)
{
  /*
  var rads = document.getElementsByName("blenzaplus_selectWidget");
  for (var i = 0; i < rads.length; i++) {
    if (rads[i].value == "NEW") rads[i].checked = true;
    else rads[i].checked = false;
  }
  */
  //var inp = document.getElementById("blenzaplus_newWidgetVader");
  if (inp.value == "<?php echo $blenzaplus_newHintVader; ?>") {
    inp.select();
  }
}
<?php } ?>

// function to get an XML request object
function blenzaplus_xmlRequest()
{
  if (window.XMLHttpRequest) return new XMLHttpRequest();
  else if (window.ActiveXObject) return new ActiveXObject("Microsoft.XMLHTTP");
  else return null;
}

// function to track changes to the starting time
function blenzaplus_updateStarts()
{
  var starts = blenzaplus_getValue("starts");
  var ends = blenzaplus_getValue("ends");

  if ((ends == "after") && (starts != "specify")) {
    starts = "specify";
    var inp = document.getElementById("blenzaplus_starts");
    blenzaplus_radioClick("starts", starts);
    alert("Widgets ending after a number of days must start on a specific date/time");
  }

  var inps = document.getElementById("blenzaplus_startsat");
  var inpe1 = document.getElementById("blenzaplus_endsat");
  var inpe2 = document.getElementById("blenzaplus_endsin");

  if (starts == "specify") inps.style.display = "inline";
  else inps.style.display = "none";

  if (ends == "specify") {
    inpe1.style.display = "inline";
    inpe2.style.display = "none";
  }
  else if (ends == "after") {
    inpe1.style.display = "none";
    inpe2.style.display = "inline";
  }
  else {
    inpe1.style.display = "none";
    inpe2.style.display = "none";
  }
}

// function to check a date to make sure it's not in the past
function blenzaplus_checkDates()
{
  var now = new Date().getTime();

  function err(s) {
    var div = document.getElementById("blenzaplus_dateError");
    if (div == null) return;
    if (s == null) div.style.display = "none";
    else div.style.display = "block";
    /*
    if (s.indexOf("*") >= 0) {
      div.style.color = "red";
    }
    else {
      div.style.color = "orange";
    }
    */
    div.innerHTML = s;
  }

  function getDate(val) {
    // first make sure the date is formatted properly
    var parts1 = val.split(" ");
    if (parts1.length != 3) return null;
    var parts2 = parts1[0].split("/");
    if (parts2.length != 3) return null;
    var parts3 = parts1[1].split(":");
    if (parts3.length != 2) return null;
    var ampm = parts1[2].toLowerCase();
    for (var i = 0; i < 3; i++) if (isNaN(parts2[i])) return null;
    for (var i = 0; i < 2; i++) if (isNaN(parts3[i])) return null;
    if ((ampm != "am") && (ampm != "pm")) return null;

    // fix up the hour and year
    var hour = parts3[0]*1;
    if (hour == 12) hour = 0;
    if (ampm == "pm") hour += 12;
    var year = parts2[2]*1;
    if (year < 1000) year += 2000;

    // next make sure the date is in the future at client locale
    var ret = new Date();
    ret.setMonth(parts2[0] - 1);
    ret.setDate(parts2[1]);
    ret.setHours(hour);
    ret.setMinutes(parts3[1]);
    ret.setFullYear(year);
    ret.setSeconds(0);
    ret.setMilliseconds(0);

    // return the time shifted by the difference from server time
    return ret.getTime() + blenzaplus_timeShift;
  }

  var startsAt;
  var endsAt;
  var starts = blenzaplus_getValue("starts");
  var ends = blenzaplus_getValue("ends");
  var inpStarts = document.getElementById("blenzaplus_startsat");
  var inpEnds = document.getElementById("blenzaplus_endsat");

  if (starts == "specify") {
    startsAt = getDate(inpStarts.value);
    if (startsAt == null) {
      err("Starting time format error.");
      inpStarts.style.color = "red";
      return;
    }
  }
  // otherwise it's already started
  else startsAt = now;

  if (ends == "specify") {
    endsAt = getDate(inpEnds.value);
    if (endsAt == null) {
      err("Ending time format error.");
      inpEnds.style.color = "red";
      return;
    }
  }
  // otherwise it doesn't matter when.
  else endsAt = startsAt + 9999999999999;

  var spanO = "<span style='color:orange'>";
  var spanR = "<span style='color:red'>";
  var spanEnd = "</span>";
  var msg = "";
/*
  if (startsAt < now) {
    msg = spanO + "Starting time is in the past." + spanEnd;
    inpStarts.style.color = "orange";
  }
  else
*/
  inpStarts.style.color = "green";

  if (endsAt < startsAt) {
    if (msg != "") msg += " ";
    msg += spanR + "Ending time is before starting time." + spanEnd;
    inpEnds.style.color = "red";
  }
  else if (endsAt - startsAt < 300000) {
    if (msg != "") msg += " ";
    msg += spanO + "Ending time too close to starting time." + spanEnd;
    inpEnds.style.color = "orange";
  }
/*
  else if (endsAt < now) {
    if (msg != "") msg += " ";
    msg += spanO + "Ending time is in the past." + spanEnd;
    inpEnds.style.color = "orange";
  }
  else
*/
  inpEnds.style.color = "green";

  if (msg == "") err(null);
  else err(msg);
}

// function 
function blenzaplus_checkExtra()
{
  var div = document.getElementById("blenzaplus_exmore");
  if (blenzaplus_getValue("extra") == "yes") div.style.display = "block";
  else div.style.display = "none";
}

// function 
function blenzaplus_checkThumbs()
{
  var div = document.getElementById("blenzaplus_thmore");
  if (blenzaplus_getValue("thumbs") == "yes") div.style.display = "block";
  else div.style.display = "none";
}
</script>
