<p>This post contains an external widget (hosted on another server) that can be imported to your server and converted to a BlenzaPlus Linky Widget.</p>

<?php if ($meta["ignoreExternal"]) { ?><p>The external widget is currently being ignored by this plug-in, but will be displayed on your site unless you choose to convert it.</p><?php } ?>

<?php if (!$meta["ignoreExternal"]) { ?><p>Click <span style="text-decoration:underline;cursor:pointer" onclick="blenzaplus_ignoreExternal(<?php echo $postid; ?>)">here</span> to ignore the external widget in this post and disable the message that appears when you view it.<?php } ?>

<p id="blenzaplus_convertExternalLink">Click <span style="text-decoration:underline;cursor:pointer" onclick="blenzaplus_convertExternalPhase(<?php echo $postid; ?>,1)">here</span> to learn more about converting the external widget in this post.</p>

<div id="blenzaplus_convertExternalWrap" style="display:none;padding:8px;border:1px solid #888">

<p>Step <span id="blenzaplus_convertExternalPhase">N</span>.</p>

<div name="blenzaplus_convertExternal" phase="1">

<p>The first step is to capture the HTML code that represents the external widget.  In this case, that HTML is the following:</p>

<p><code><span id="blenzaplus_externalCode"><?php print_r(htmlentities($extCode[0])); ?></span></code></p>

<p>When you click Next, a copy of the external widget code will be stored for safekeeping, but it will not be removed from the post until its links have been imported.</p>

<p>In Step 2, we will prepare to import information from the external widget.</p>

</div>

<div name="blenzaplus_convertExternal" phase="2">

<p>The next step is to retrieve information from the external widget.  To do that we will connect to the remote server (<span id="blenzaplus_externalServer">If you can read this, the server could not be located.  Please <a href="mailto:mister.linky@gmail.com?subject=blenzaplus-msg002">report this problem</a>.</span>) using the widget&#39;s unique identifier.  In this case, that identifier is the following:</p>

<p><code><span id="blenzaplus_externalParams">If you can read this, the parameters could not be located.  Please <a href="mailto:mister.linky@gmail.com?subject=blenzaplus-msg003">report this problem</a>.</span></code></p>

<p>When you click Next, information will be retrieved from the remote server, but no other changes will be made.</p>

<p>In Step 3, we will compare the external widget with the information we imported and verify that it was done correctly.</p>

</div>

<div name="blenzaplus_convertExternal" phase="3">

<p>Now it&#39;s time to make sure we have imported the right set of links.</p>

<p>Here is a live instance of the external widget in this post:</p>

<iframe width="450" height="100" id="blenzaplus_externalDisplay" src="<?php echo $blenzaplus_homeUrl; ?>/editform-external-dummy.php">
Sorry, there is an IFRAME tag that is essential to the operation of this application.
</iframe>

<p>And here is a newly created (but not yet active) BlenzaPlus Linky Widget using the imported links:</p>

<p id="blenzaplus_externalContent"></p>

<p>Compare the two widgets and click Next once you are satisfied that the new widget has the correct links.</p>

<p>In Step 4, we will remove the external widget code from this post and activate the new BlenzaPlus Linky Widget to take its place.</p>

</div>

<div name="blenzaplus_convertExternal" phase="4">

<p>Now that the external widget has been imported, it may be removed from the post.</p>

<p>Click Next to remove the external widget code from this post and activate the new BlenzaPlus Linky Widget.</p>

</div>

<div name="blenzaplus_convertExternal" phase="5">

<p>Conversion completed!</p>

<p>Click Done to continue.</p>

</div>

<input type="button" id="blenzaplus_convertBtnNext" value="Next" onclick="blenzaplus_convertExternalNext(<?php echo $postid; ?>)">

<input type="button" id="blenzaplus_convertBtnPrev" value="Prev" onclick="blenzaplus_convertExternalPrev(<?php echo $postid; ?>)">

<input type="button" id="blenzaplus_convertBtnCancel" value="Cancel" onclick="blenzaplus_convertExternalPhase(<?php echo $postid; ?>, 0)">

</div>

