<script type="text/javascript">
function blenzaplus_convertExternalNext(n)
{
  var div = document.getElementById("blenzaplus_convertExternalWrap");
  var currentPhase = div.getAttribute("currentPhase") * 1;
  phase = currentPhase + 1;

  // if we're going from phase 1 to phase 2, we're saving the external
  // widget code into the postmetadata.  we're also generating the url
  // that will be used for gathering links from the remote server.
  if (phase == 2) {
    var arr = blenzaplus_prepareExternalWidget(n);
    if (arr == null) throw "Could not retrieve externalLinks";
    server = arr[0];
    params = arr[1];
    display = arr[2];
    var ele = document.getElementById("blenzaplus_externalServer");
    if (ele == null) throw "Cannot locate element on page";
    ele.innerHTML = server;
    var ele = document.getElementById("blenzaplus_externalParams");
    if (ele == null) throw "Cannot locate element on page";
    ele.innerHTML = params;
    var ele = document.getElementById("blenzaplus_externalDisplay");
    if (ele == null) throw "Cannot locate element on page";
    ele.src = display;
    blenzaplus_convertExternalPhase(n, phase);
    return;
  }

  // if we're going from phase 2 to phase 3, we're retrieving the
  // links from the remote server and displaying a sample widget along
  // with the remote widget for verification.
  if (phase == 3) {
    var content = blenzaplus_convertExternalWidget(n);
    if (content == null) throw "No content returned by convert";
    var ele = document.getElementById("blenzaplus_externalContent");
    if (ele == null) throw "Cannot locate external code on page";
    ele.innerHTML = content;
    blenzaplus_convertExternalPhase(n, phase);
    return;
  }

  // if we're going from phase 3 to phase 4, there is nothing to do.
  if (phase == 4) {
    blenzaplus_convertExternalPhase(n, phase);
    return;
  }

  // if we're going from phase 4 to phase 5, we're removing the
  // external widget code from the post and enabling the new widget.
  // let's also disable the next/prev buttons and change cancel to done.
  if (phase == 5) {
    if (!blenzaplus_finishExternalWidget(n)) return;
    var btn = document.getElementById("blenzaplus_convertBtnCancel");
    btn.value = "Done";
    blenzaplus_convertExternalPhase(n, phase);
    return;
  }
}

function blenzaplus_convertExternalPrev(n)
{
  var div = document.getElementById("blenzaplus_convertExternalWrap");
  var currentPhase = div.getAttribute("currentPhase") * 1;
  phase = currentPhase - 1;

  // going backwards, there is nothing to "undo" so just display the
  // appropriate section of the form.
  blenzaplus_convertExternalPhase(n, phase);
}
</script>
