<script type="text/javascript">
// go ahead and update the widget preview when the script is loaded
updateWidgetPreview(true);

// function to upgrade the widget preview when the configuration changes
function updateWidgetPreview(init)
{
  // determine color configuration from the user's choices
  var colorsStr = blenzaplus_getValue("colors");
  var foreColor = null;
  var backColor = null;
  var colCustom = document.getElementById("blenzaplus_colorsCustom");
  if (colorsStr == "custom") {
    colCustom.style.display = "block";
  }
  else {
    colCustom.style.display = "none";
  }
  if (colorsStr == "bw") {
    foreColor = "#000";
    backColor = "#fff";
  }
  else if (colorsStr == "wb") {
    foreColor = "#fff";
    backColor = "#000";
  }
  else {
    inp = document.getElementById("blenzaplus_colorCode_fore");
    foreColor = inp.value;
    inp = document.getElementById("blenzaplus_colorCode_back");
    backColor = inp.value;
  }

  // determine width configuration from the user's choices.
  var widthStr = blenzaplus_getValue("width");
  var widCustom = document.getElementById("blenzaplus_widthCustom");
  if (widthStr == "custom") widCustom.style.display = "block";
  else widCustom.style.display = "none";
  if (widthStr == "narrow") width = 400;
  else if (widthStr == "wide") width = 600;
  else {
    inp = document.getElementById("blenzaplus_widthVal");
    width = inp.value;
  }

  // determine font (face) configuration from the user's choices.
  var fontStr = blenzaplus_getValue("font");
  var ffCustom = document.getElementById("blenzaplus_fontCustom");
  if (fontStr == "custom") ffCustom.style.display = "block";
  else ffCustom.style.display = "none";
  if (fontStr == "plain") font = 'Arial,sans-serif';
  else if (fontStr == "fancy") font = '"Times New Roman",Georgia,serif';
  else {
    inp = document.getElementById("blenzaplus_fontVal");
    font = inp.value;
  }

  // determine font (size) configuration from the user's choices.
  var fontStr = blenzaplus_getValue("fsize");
  var fsCustom = document.getElementById("blenzaplus_fsizeCustom");
  if (fontStr == "custom") fsCustom.style.display = "block";
  else fsCustom.style.display = "none";
  if (fontStr == "small") fsize = "10";
  else if (fontStr == "large") fsize = "12";
  else {
    inp = document.getElementById("blenzaplus_fsizeVal");
    fsize = inp.value;
  }

  // how many columns of output did the user choose?
  var columns = blenzaplus_getValue("columns");

  // determine whether the user would prefer the comment form checkbox
  // or the name/link data entry form
  var comments = blenzaplus_getValue("comments");
  var div1 = document.getElementById("blenzaplus_widgetComment");
  var div2 = document.getElementById("blenzaplus_widgetEntry");
  if (comments == "yes") {
      div1.style.display = "block";
      div2.style.display = "none";
  }
  else if (comments == "no") {
      div1.style.display = "none";
      div2.style.display = "block";
  }

  // determine whether we will have an "extra" box by default
  var extra = blenzaplus_getValue("extra");
  var row = document.getElementById("blenzaplus_extraRow");
  var tab = document.getElementById("blenzaplus_entryTable");
  var rows = tab.getElementsByTagName("tr");
  if (extra == "yes") {
    if (rows.length == 3) {
      var row = rows[0].cloneNode(true);
      var tds = row.getElementsByTagName("td");
      var spans = tds[0].getElementsByTagName("span");
      var span = spans[0];
      span.innerHTML = span.innerHTML.replace("Name", "Extra");
      rows[2].parentNode.insertBefore(row, rows[2]);
    }
  }
  else if (extra == "no") {
    if (rows.length == 4) {
      rows[2].parentNode.removeChild(rows[2]);
    }
  }

  // determine whether we will have thumbnails by default
  var thumbs = blenzaplus_getValue("thumbs");
  var row = document.getElementById("blenzaplus_thumbsRow");
  var tab = document.getElementById("blenzaplus_entryTable");
  var rows = tab.getElementsByTagName("tr");
  var more = document.getElementById("blenzaplus_thumbsMore");
  if (thumbs == "yes") {
    if (rows.length == 3) {
      var row = rows[0].cloneNode(true);
      var tds = row.getElementsByTagName("td");
      var spans = tds[0].getElementsByTagName("span");
      var span = spans[0];
      span.innerHTML = span.innerHTML.replace("Name", "Thumbs");
      rows[2].parentNode.insertBefore(row, rows[2]);
    }
    more.style.display = "";
  }
  else if (thumbs == "no") {
    if (rows.length == 4) {
      rows[2].parentNode.removeChild(rows[2]);
    }
    more.style.display = "none";
  }

  // determine whether the blog's administrator should see a widget
  // selector on each post
  var selector = blenzaplus_getValue("selector");
  var div = document.getElementById("blenzaplus_widgetSelector");
  if (selector == "yes") {
      div.style.display = "block";
  }
  else if (selector == "no") {
      div.style.display = "none";
  }

  // update the width of the widget preview from configuration
  var wid;
  var inn;
  try {
    var pre = document.getElementById("blenzaplus_preview");
    var divs = pre.getElementsByTagName("div");
    wid = divs[0];
    var inns = wid.getElementsByTagName("span");
    inn = inns[3];
  }
  catch (e) {
    return;
  }
  if ((width > 99) && (width < window.innerWidth - 99)) {
    wid.style.width = width + "px";

    var tds = wid.getElementsByTagName("td");
    for (var i = 0; i < tds.length-1; i++) {
      tds[i+1].width = width - 80;
      i++;
    }

    var ins = wid.getElementsByTagName("input");
    for (var i = 0; i < ins.length; i++) {
      if (ins[i].type != "text") continue;
      ins[i].style.width = (width-100) + "px";
    }
  }

  // update the background color of the widget preview from configuration
  wid.style.border = "1px solid " + foreColor;
  wid.style.background = backColor;

  // update the foreground (text) color of the preview from configuration
  var spans = wid.getElementsByTagName("span");
  for (var i = 0; i < spans.length; i++) {
    if (spans[i].className != "blenzaplus_text") continue;
    spans[i].style.color = foreColor;
    spans[i].style.fontFamily = font;
    spans[i].style.fontSize = fsize + "pt";
  }
  var spans = wid.getElementsByTagName("a");
  for (var i = 0; i < spans.length; i++) {
    spans[i].style.color = foreColor;
    spans[i].style.fontFamily = font;
    spans[i].style.fontSize = fsize + "pt";
  }

  // add some sample data more or less randomly to the widget preview
  var datas = 
    [
     ["George Washington", "John Adams", "Thomas Jefferson", "James Madison", "James Monroe"],
     ["Steve Allen", "Jack Paar", "Johnny Carson", "Jay Leno", "Conan O&#39;Brien"],
     ["Andrea", "Barry", "Chantal", "Dorian", "Erin", "Fernand", "Gabrielle", "Humberto", "Ingrid", "Jerry", "Karen"],
     ["Lorenzo", "Melissa", "Nestor", "Olga", "Pablo", "Rebekah", "Sebastien", "Tanya", "Van", "Wendy"]
     ];
  var di = new Date().getHours() % datas.length;
  var data = datas[di];
  data.push("You&#39;re next!");
  var tw = width;
  var cw = (columns == 3) ? 33 : (columns == 2) ? 50 : 100;
  var pc = Math.floor((data.length + (columns-1)) / columns);
  tdtop = "<td valign='top' align='left' width='" + cw + "%'>";
  var html = "<table style='' width='" + tw + "px' cellpadding=0 cellspacing=0><tr>";
  var n = 1;
  for (var i = 0; i < data.length; i++) {
    var name = data[i];
    var link = ((i+1) < data.length);
    html += tdtop;
    html += "<span class='blenzaplus_text' style='color:" + foreColor + ";font-family:" + font + ";font-size:" + fsize + "pt;'>" + (i+1) + ". " + "</span>";
    if (link) html += "<a style='color:" + foreColor + ";font-family:" + font + ";font-size:" + fsize + "pt;' href='javascript:;' onclick='alert(\"Links are not live in preview\");'>";
    html += "<span class='blenzaplus_text' style='color:" + foreColor + ";font-family:" + font + ";font-size:" + fsize + "pt;'>" + name + "</span>";
    if (link) html += "</a>";
    html += "</td>";
    if (((n % columns) == 0)) html += "</tr><tr>";
    n++;
  }
  html += "</td></tr></table>";
  inn.innerHTML = html;

  // if we're here because we're just starting up, we're done.
  if (init) return;

  // when configuration changes, display a handy link for saving it.
  var warn = document.getElementById("blenzaplus_warning");
  warn.style.display = "block";
}

// function called when a color is selected from widget configuration
function blenzaplus_selectColor(name, color)
{
  // helper inner function to convert a number to hex.
  function toHex(n)
  {
    var nn = new Number(n);
    var hh = nn.toString(16);
    if (hh.length == 2) return hh;
    if (hh.length == 1) return "0" + hh;
    if (hh.length == 0) return "00";
    return hh.substr(0, 2);
  }

  // convert rgb() style to #rrggbb
  var str;
  if (color.substr(0, 1) == "#") str = color;
  else if (color.substr(0, 4) == "rgb(") {
    var colorArr = color.substr(4).substr(0, color.length-5).split(",");
    str = "#" + toHex(colorArr[0]) + toHex(colorArr[1]) + toHex(colorArr[2]);
  }
  else str = color;
  var inp = document.getElementById("blenzaplus_colorCode_" + name);
  inp.value = str;
  updateWidgetPreview();
}

// function called when user clicks the Update Configuration link we
// display so you don't have to scroll down and click the button.
function blenzaplus_updateConfig()
{
  var forms = document.getElementsByTagName("form");
  if (forms.length == 1) return forms[0].submit();
  for (var i = 0; i < forms.length; i++) {
    if (forms[i].action == "") return forms[i].submit();
  }
  alert("Please click the Update Configuration button.");
}

function blenzaplus_keystored()
{
  var ele = document.getElementById("blenzaplus_removeKey");
  if (ele.style.display == "none") ele.style.display = "inline";
  else ele.style.display = "none";
}

function blenzaplus_uptodate()
{
  var ele = document.getElementById("blenzaplus_updatenow");
  if (ele.style.display == "none") ele.style.display = "inline";
  else ele.style.display = "none";
}

function blenzaplus_unregister()
{
  if (!confirm("Are you sure you wish to remove your registration key? (This will effectively disable the widget!)")) return;

  var req = null;
  try {
    // send the request to the server.
    req = blenzaplus_xmlRequest();
    var url = "<?php echo $blenzaplus_homeUrl; ?>/unregister.php";
    req.open("POST", url, false);
    req.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
    req.send(data);

    // handle unexpected problems
    if (req.readyState != 4) throw "State " + req.readyState;
    if (req.status != 200) throw "Status " + req.status;
    if (req.responseXML == null) throw "No XML returned";

    // handle expected return data
    var data = req.responseXML.getElementsByTagName("blenzaplus");
    if ((data == null) || (data.length != 1)) throw "No data returned";

    // parse the data that did come back.
    var errorRet = null;
    var errorTag = data[0].getElementsByTagName("error");
    if (errorTag.length > 0) errorRet = errorTag[0].firstChild.data;
    var statusRet = null;
    var statusTag = data[0].getElementsByTagName("status");
    if (statusTag.length > 0) statusRet = statusTag[0].firstChild.data;

    // make sure the operation succeeded
    if (errorRet) throw errorRet;
    if (statusRet != "OK") throw "Internal error";

    // success!
    if (confirm("Your registration key has bee removed. Do you wish to reload this page?")) blenzaplus_reload();
  }
  catch (e) {
    var msg = "An error occurred processing the request.\n\n" + e;
    if (url) msg += "\n\nURL: " + url;
    if (req.responseText) msg += "\n\n" + req.responseText;
    msg += "\n\nIf you would be so kind as to email this error text (or screen capture) to mister.linky@gmail.com it will be addressed as soon as possible.";
    alert(msg);
    return null;
  }
}

function blenzaplus_generic(name, data)
{
  var req = null;
  try {
    // send the request to the server.
    req = blenzaplus_xmlRequest();
    var url = "<?php echo $blenzaplus_homeUrl; ?>/" + name + ".php";
    req.open("POST", url, false);
    req.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
    req.send(data);

    // handle unexpected problems
    if (req.readyState != 4) throw "State " + req.readyState;
    if (req.status != 200) throw "Status " + req.status;
    if (req.responseXML == null) throw "No XML returned";

    // handle expected return data
    var data = req.responseXML.getElementsByTagName("blenzaplus");
    if ((data == null) || (data.length != 1)) throw "No data returned";

    // parse the data that did come back.
    var errorRet = null;
    var errorTag = data[0].getElementsByTagName("error");
    if (errorTag.length > 0) errorRet = errorTag[0].firstChild.data;
    var statusRet = null;
    var statusTag = data[0].getElementsByTagName("status");
    if (statusTag.length > 0) statusRet = statusTag[0].firstChild.data;

    // make sure the operation succeeded
    if (errorRet) throw errorRet;
    if (statusRet != "OK") throw "Internal error";

    // success!
    return data;
  }
  catch (e) {
    var msg = "An error occurred processing the request.\n\n" + e;
    if (url) msg += "\n\nURL: " + url;
    if (req.responseText) msg += "\n\n" + req.responseText;
    msg += "\n\nIf you would be so kind as to email this error text (or screen capture) to mister.linky@gmail.com it will be addressed as soon as possible.";
    alert(msg);
    return null;
  }
}

function blenzaplus_updateSwitch()
{
  var div1 = document.getElementById("blenzaplus_update1");
  if (div1 == null) return alert("Could not locate div #1");
  var div2 = document.getElementById("blenzaplus_update2");
  if (div2 == null) return alert("Could not locate div #2");
  if (div1.style.display == "none") div1.style.display = "inline";
  else div1.style.display = "none";
  if (div2.style.display == "none") div2.style.display = "inline";
  else div2.style.display = "none";
}

function blenzaplus_beginUpdate(btn)
{
  var inp = document.getElementById("blenzaplus_updateHost");
  if (inp == null) return alert("Could not locate input for Host name");
  var hostname = inp.value;
  var inp = document.getElementById("blenzaplus_updateUser");
  if (inp == null) return alert("Could not locate input for User name");
  var username = inp.value;
  var inp = document.getElementById("blenzaplus_updatePass1");
  if (inp == null) return alert("Could not locate input for Password");
  var password = inp.value;
  var inp = document.getElementById("blenzaplus_updatePass2");
  if (inp == null) return alert("Could not locate input for Password");
  var password2 = inp.value;
  if (password != password2) return alert("Password entries to not match");

  // enough obfuscation to hide the data from prying eyes.
  var length = hostname.length * 1000000 + username.length * 1000 + password.length;
  var chars = "";
  for (var i = 0; i < hostname.length; i++) {
    var n = hostname.charCodeAt(i);
    chars += n.toString(16);
  }
  for (var i = 0; i < username.length; i++) {
    var n = username.charCodeAt(i);
    chars += n.toString(16);
  }
  for (var i = 0; i < password.length; i++) {
    var n = password.charCodeAt(i);
    chars += n.toString(16);
  }
  var evens = "";
  var odds = "";
  for (var i = 0; i < chars.length; i+=2) {
    evens += chars.charAt(i);
    odds += chars.charAt(i+1);
  }
  var data = "a=" + length + "&b=" + evens + odds;

  var btnVal = btn.value;
  btn.value = "Please wait...";
  btn.disabled = true;
  var ret = blenzaplus_generic("update", data);
  btn.disabled = false;
  btn.value = btnVal;

  if (ret == null) return;

  var filesRet = 0;
  var filesTag = ret[0].getElementsByTagName("files");
  if (filesTag.length > 0) filesRet = filesTag[0].firstChild.data;
  var imagesRet = 0;
  var imagesTag = ret[0].getElementsByTagName("images");
  if (imagesTag.length > 0) imagesRet = imagesTag[0].firstChild.data;
  var total = (filesRet * 1) + (imagesRet * 1);

  if (confirm("Update completed. Downloaded " + total + " files (" + filesRet + " text, " + imagesRet + " images). Do you wish to reload this page?")) blenzaplus_reload();
}

function blenzaplus_updateIgnore()
{
  var ret = blenzaplus_generic("updateignore", null);
  if (ret == null) return;
  if (confirm("The new plug-in version will be ignored. Do you wish to reload this page?")) blenzaplus_reload();
}

function blenzaplus_updatenow()
{
  var ret = blenzaplus_generic("updatenow", null);
  if (ret == null) return;
  if (confirm("The update server has been queried. Do you wish to reload this page?")) blenzaplus_reload();
}

function blenzaplus_database()
{
  var ret = blenzaplus_generic("database", null);
  if (ret == null) return;
  if (confirm("The database has been updated. Do you wish to reload this page?")) blenzaplus_reload();
}

function blenzaplus_viewReadme()
{
  var ret = blenzaplus_generic("viewreadme", null);
  if (ret == null) return;
  var readmeRet = 0;
  var readmeTag = ret[0].getElementsByTagName("readme");
  if (readmeTag.length > 0) readmeRet = readmeTag[0].firstChild.data;
  alert(readmeRet);
}

function blenzaplus_acceptLicense()
{
  var ret = blenzaplus_generic("acceptlicense", null);
  if (ret == null) return;
  var div1 = document.getElementById("blenzaplus_license1");
  if (div1 == null) return alert("Could not locate div #1");
  var div2 = document.getElementById("blenzaplus_license2");
  if (div2 == null) return alert("Could not locate div #2");
  if (div1.style.display == "none") div1.style.display = "inline";
  else div1.style.display = "none";
  if (div2.style.display == "none") div2.style.display = "inline";
  else div2.style.display = "none";
}

function blenzaplus_testThumbLocs()
{
  var int = document.getElementById("blenzaplus_thint");
  if (int == null) return alert("Could not locate int");
  var ext = document.getElementById("blenzaplus_thext");
  if (ext == null) return alert("Could not locate ext");
  var span = document.getElementById("blenzaplus_thumbStatus");
  var data = "int=" + escape(int.value) + "&ext=" + escape(ext.value);
  var ret = blenzaplus_generic("testthumbs", data);
  if ((ret == null) || (ret.length == 0)) return;
  var retMsg = ret[0].getElementsByTagName("message");
  if ((retMsg == null) || (retMsg.length == 0)) return alert("Could not find msg");
  var retCol = ret[0].getElementsByTagName("color");
  var color;
  if ((retCol == null) || (retCol.length == 0)) color = "black";
  else color = retCol[0].firstChild.data;
  span.innerHTML = retMsg[0].firstChild.data;
  span.style.color = color;
}
</script>
