<style type="text/css">
p {
  margin:4px 0px;
  padding:0px;
}
</style>

<div class="wrap">
<h2><img width="21" height="21" src="<?php echo $blenzaplus_homeUrl; ?>/images/linkarrow24.png"> BlenzaPlus Configuration</h2>
<form method="POST">

<!-- ---------------------------------------- -->

<?php
// Regstration
$now = time();
$accepted = (get_option("blenzaplus_licenseAccepted") != null);
$key = get_option("blenzaplus_key");
if ($key == null) {
  include "registration.php";
}
else {
  $expiry = get_option("blenzaplus_expiry");
  include "registration-done.php";
}
if (get_option("blenzaplus_error")) {
  echo "<p style=\"color:red\">Internal error: <i>".get_option("blenzaplus_error")."</i></p>";
}
?>
<hr/>

<!-- ---------------------------------------- -->

<?php
$sql = file_get_contents("{$blenzaplus_homeDir}/database.sql");
if (md5($sql) != get_option("blenzaplus_database")) {
  include "config-database.php";
}
?>

<!-- ---------------------------------------- -->

<?php
$latest = get_option("blenzaplus_latest");
$updated = get_option("blenzaplus_updated");
if ($latest > $updated) {
  include "config-update.php";
}
else {
  include "config-updated.php";
}
?>

<!-- ---------------------------------------- -->

<?php
// target=_blank configuration
$target = get_option("blenzaplus_target");
if ($target == null) $target = "yes";
displayRadios("target", $target,
  "Should widget links open pages in a new window?", array(
  array("value"=>"yes", "label"=>"Yes (tends to encourage longer visits)"),
  array("value"=>"no", "label"=>"No")));
?>
<hr/>

<!-- ---------------------------------------- -->

<?php
// rel=nofollow configuration
$nofollow = get_option("blenzaplus_nofollow");
if ($nofollow == null) $nofollow = "yes";
displayRadios("nofollow", $nofollow,
  "Should widget links use the NOFOLLOW attribute?  <small>Learn more <a href='http://en.wikipedia.org/wiki/Nofollow' target='_blank'>here</a> (in a new window)</small>.",
  array(
  array("value"=>"yes", "label"=>"Yes (tends to discourage spammers)"),
  array("value"=>"no", "label"=>"No")));
?>
<hr/>

<!-- ---------------------------------------- -->

<?php
// setup foreground/background color configuration
list($colorsStr, $colors) = blenzaplus_getColors();
list($alignmentStr, $alignment) = blenzaplus_getAlignment();
list($fontStr, $font) = blenzaplus_getFontFamily();
list($fsizeStr, $fsize) = blenzaplus_getFontSize();
list($widthStr, $width) = blenzaplus_getWidth();

$colsStr = get_option("blenzaplus_columns");
if ($colsStr == null) $colsStr = 3;

$cOptions = array(
   array("value"=>"bw", "label"=>"Black on white"),
   array("value"=>"wb", "label"=>"White on black"),
   array("value"=>"custom", "label"=>"Custom"));
$wOptions = array(
   array("value"=>"narrow", "label"=>"Narrow"),
   array("value"=>"wide", "label"=>"Wide"),
   array("value"=>"custom", "label"=>"Custom"));
$aOptions = array(
   array("value"=>"left", "label"=>"Left"),
   array("value"=>"center", "label"=>"Center"),
   array("value"=>"right", "label"=>"Right"));
$ffOptions = array(
   array("value"=>"plain", "label"=>"Plain"),
   array("value"=>"fancy", "label"=>"Fancy"),
   array("value"=>"custom", "label"=>"Custom"));
$fsOptions = array(
   array("value"=>"small", "label"=>"Small"),
   array("value"=>"large", "label"=>"Large"),
   array("value"=>"custom", "label"=>"Custom"));
$colOptions = array(
   array("value"=>"1", "label"=>"1"),
   array("value"=>"2", "label"=>"2"),
   array("value"=>"3", "label"=>"3"));

// setup entry configuration (comment checkbox or name/link form)
$comments = get_option("blenzaplus_comments");
if ($comments == null) $comments = "yes";

// setup extra box option configuration
$extra = get_option("blenzaplus_extra");
if ($extra == null) $extra = "no";

// setup thumbnails option configuration
$thumbs = get_option("blenzaplus_thumbs");
if ($thumbs == null) $thumbs = "no";

// setup widget selector option configuration
$selector = get_option("blenzaplus_selector");
if ($selector == null) $selector = "yes";

// setup host name repeat option configuration
$repeat = blenzaplus_isOption("repeat");
if (($repeat === false) || ($repeat == null)) $repeat = "no";
else $repeat = "yes";

// setup widget connect option configuration
$connect = blenzaplus_isOption("connect");
if (($connect === false) || ($connect == null)) $connect = "no";
else $connect = "yes";

// function to display the select and option tags, as well as the
// color pallette, inc case it's needed
function displayOptions($name, $strval, $label, $options, $more = null)
{
  // display the select tag and options
  echo "<p>{$label}:<br>";
  echo "<select id='blenzaplus_{$name}' name='blenzaplus_{$name}' onchange='updateWidgetPreview()'>";
  foreach ($options as $option) {
    echo "&nbsp;";
    echo "<option ";
    if ($strval == $option["value"]) echo "selected";
    echo " value='";
    echo $option["value"];
    echo "'>";
    echo "&nbsp;";
    echo $option["label"];
    echo "<br>";
  }
  echo "</select>";
  echo "</p>";

  // display a table for the color pallettes (fore/background), in
  // case the user wants to customize the colors of the widget
  echo "<table id='blenzaplus_{$name}Custom' style='width: 300px; border: 1px solid #000;display:none'>";
  if ($more == null) $imax = 0;
  else if ($name != "colors") $imax = 1;
  else $imax = 2;
  for ($i = 0; $i < $imax; $i++) {
    echo "<tr><td valign='top'>";
    if ($name != "colors") echo "{$label}: ";
    else if ($i == 0) echo "Text/Borders: ";
    else if ($i == 1) echo "Background";
    echo "</td>";
    echo "<td valign='top' width='192px'>";
    if ($name != "colors") echo "<input style='text-height:12px;padding:0px' id='blenzaplus_{$name}Val' name='blenzaplus_{$name}Val' value='{$more}' size='8' onkeyup='updateWidgetPreview()' onchange='updateWidgetPreview()'>";
    else if ($i == 0) displayPallette("fore", $more);
    else if ($i == 1) displayPallette("back", $more);
    echo "</td></tr>";
  }
  echo "</table>";
}

// function to display a set of radio buttons
function displayRadios($name, $value, $label, $options)
{
  echo "<p>";
  echo $label;
  echo "</p>";
  echo "<p>";
  foreach ($options as $option) {
    echo "<input ";
    if ($value == $option["value"]) echo "checked";
    echo " name='blenzaplus_{$name}'";
    echo " type='radio'";
    echo " value='";
    echo $option["value"];
    echo "'";
    echo " onclick='updateWidgetPreview()'";
    echo ">";
    echo "&nbsp;";
    echo "<span onclick='blenzaplus_radioClick(\"{$name}\",\"{$option["value"]}\");updateWidgetPreview();'>";
    echo $option["label"];
    echo "</span>";
    echo "<br>";
  }
  echo "</p>";
}

// display one of the color pallettes
function displayPallette($name, $colors)
{
  $pallette = array
    (
     array("value"=>"#c00", "label"=>"Red"),
     array("value"=>"#fb940b", "label"=>"Orange"),
     array("value"=>"#ff0", "label"=>"Yellow"),
     array("value"=>"#0c0", "label"=>"Green"),
     array("value"=>"#03c0c6", "label"=>"Teal"),
     array("value"=>"#00f", "label"=>"Blue"),
     array("value"=>"#762ca7", "label"=>"Purple"),
     array("value"=>"#ff98bf", "label"=>"Pink"),
     array("value"=>"#fff", "label"=>"White"),
     array("value"=>"#999", "label"=>"Gray"),
     array("value"=>"#000", "label"=>"Black"),
     array("value"=>"#885418", "label"=>"Brown"),
     );
  $n = 0;
  foreach ($pallette as $pal) {
    echo "<div style='position:relative'>";
    echo "<div title='{$pal["label"]}' style='position:absolute;top:0px;left:{$n}px;height:12px;width:12px;background:{$pal["value"]};border:1px solid #000' onclick='blenzaplus_selectColor(\"{$name}\", this.style.backgroundColor)'>&nbsp;</div>";
    echo "</div>";
    $n += 16;
  }
  echo "<br>rgb: <input style='text-height:12px;padding:0px' id='blenzaplus_colorCode_{$name}' name='blenzaplus_colorCode_{$name}' value='{$colors[$name]}' size='8' onkeyup='updateWidgetPreview()' onchange='updateWidgetPreview()'>";
}
?>
<div style="float:right">
<div id="blenzaplus_preview">
<?php
// display the widget preview
$title = "Title goes here";
$description = "This would be a description of the meme or blog hop or whatever game you're playing.";
include "widget-top.php";
include "widget-body.php";
include "widget-links.php";
echo "<div id='blenzaplus_widgetEntry' style='display:";
if ($comments == "yes") echo "none"; else echo "block";
echo "'>";
include "widget-entry.php";
echo "</div>";
echo "<div id='blenzaplus_widgetComment' style='display:";
if ($comments == "yes") echo "block"; else echo "none";
echo "'>";
include "widget-comment.php";
echo "</div>";
include "widget-bot.php";
?>
</div>
<?php
// display the selector preview
echo "<div id='blenzaplus_widgetSelector' style='display:";
if ($selector == "yes") echo "block"; else echo "none";
echo "'>";
blenzaplus_selector();
echo "</div>";
?>
<br>

<div id="blenzaplus_warning" style="display:none;position:fixed;bottom:0px;right:0px;padding:2px;color:#f00;background:#fff;border-top:1px solid #777;border-left:1px solid #777;">Click <a style="color:#f00;" href="javascript:;" onclick="blenzaplus_updateConfig();">Update Configuration</a> to save settings</div>
</div>
<p>Set your widget color scheme, font/size, width, number of columns.

<?php displayOptions("colors", $colorsStr, "Colors", $cOptions, $colors); ?>
<?php displayOptions("font", $fontStr, "Font", $ffOptions, $font); ?>
<?php displayOptions("fsize", $fsizeStr, "Size", $fsOptions, $fsize); ?>
<?php displayOptions("width", $widthStr, "Width", $wOptions, $width); ?>
<?php displayOptions("alignment", $alignmentStr, "Alignment", $aOptions, $alignment); ?>
<?php displayOptions("columns", $colsStr, "Number of columns", $colOptions); ?>

<p><small>NOTE: number-of-columns can be changed on a per-post basis.</small></p>
<hr align="left" width="50%"/>

<!-- ---------------------------------------- -->

<?php
// accept entry configuration
displayRadios("comments", $comments,
  "Would you like a checkbox for adding links during commenting?",
  array(
  array("value"=>"yes", "label"=>"Yes (tends to discourage spammers)"),
  array("value"=>"no", "label"=>"No (alternative is a Name/Link form)")));
?>
<hr align="left" width="50%"/>

<!-- ---------------------------------------- -->

<?php
// accept extra box option configuration
displayRadios("extra", $extra,
  "Would you like an extra box for more information?",
  array(
  array("value"=>"yes", "label"=>"Yes (lets visitors type the name of a tip or recipe or something)"),
  array("value"=>"no", "label"=>"No (just get the visitor's name and link)")));
?>
<p><small>NOTE: extra-box can be changed on a per-post basis.</small></p>
<hr align="left" width="50%"/>

<?php
// accept thumbnails option configuration
//if (false) 
displayRadios("thumbs", $thumbs,
  "Would you like to accept and display thumbnail images?",
  array(
  array("value"=>"yes", "label"=>"Yes (lets visitors enter an image to be converted to a thumbnail)"),
  array("value"=>"no", "label"=>"No (just get the visitor's name and link)")));
?>

<div id="blenzaplus_thumbsMore" style="display:none;width:50%;border:1px solid #777;padding:4px;margin:8px 0px 8px 8px">
<small>Enter the disc/web locations for your thumbnail files. The disc location must be writable by your web server process, and the web location must be its http:// equivalent.</small>
<?php
$stint = "&nbsp;";
$thint = get_option("blenzaplus_thumbInt");
if ($thint == null) {
  $stint = "Please TEST your configuration";
  $thint = ABSPATH . "thumbnails";
}
$thext = get_option("blenzaplus_thumbExt");
if ($thext == null) {
  $thext = get_option('siteurl') . "/thumbnails";
  $stint = "Please TEST your configuration";
}
?>
<table>
<tr>
<td>Disc:&nbsp;</td>
<td><input style='text-height:9px;padding:0px' name="blenzaplus_thint" id="blenzaplus_thint" size="40" value="<?php echo $thint; ?>"></td>
</tr>
<tr>
<td>Web:&nbsp;</td>
<td><input style='text-height:9px;padding:0px' name="blenzaplus_thext" id="blenzaplus_thext" size="40" value="<?php echo $thext; ?>"></td>
</tr>
<tr>
<td>&nbsp;</td>
<td><input type="button" value="Test" onclick="blenzaplus_testThumbLocs()"> <span id="blenzaplus_thumbStatus" style="color:red"><?php echo $stint; ?></span></td>
</tr>
</table>
</div>
<p><small>NOTE: thumbnails may be enabled/disabled on a per-post basis, but must be configured here.</small></p>
<hr align="left" width="50%"/>

<?php
// accept widget selector option configuration
displayRadios("selector", $selector,
  "Would you like a widget selector to appear in each post?",
  array(
  array("value"=>"yes", "label"=>"Yes (lets you pick a widget without visiting the post editor)"),
  array("value"=>"no", "label"=>"No")));
?>
<hr align="left" width="50%"/>

<?php
// accept host name repeat option configuration
displayRadios("repeat", $repeat,
  "Would you like the system to notice repeated host names in visitors' links?",
  array(
  array("value"=>"yes", "label"=>"Yes"),
  array("value"=>"no", "label"=>"No")));
?>
<hr/>

<?php
// accept widget connect option configuration
displayRadios("connect", $connect,
  "Would you like the system to connect to and validate each visitor's link?",
  array(
  array("value"=>"yes", "label"=>"Yes"),
  array("value"=>"no", "label"=>"No")));
?>
<hr/>

<!-- ---------------------------------------- -->

<p><input type="submit" value="Update Configuration"></p>
</form>
</div>
