<?php
// include bits of wordpress so we can use the database, etc.
include "wordpress.php";

// make sure the current user is an administrator of this site.
if (!current_user_can('level_10')) sendError("Not authorized");

// get the request parameters for the action.
$ty = blenzaplus_stripRequest("ty");
$op = blenzaplus_stripRequest("op");
$id = blenzaplus_stripRequest("id");

// at this time, only widget actions are supported here.
if ($ty != "widget") sendError("Unknown type");

// perform the necessary operation for the widget
if ($op == "delete") {
  $sql = $wpdb->prepare("delete from {$wpdb->prefix}blenzaplusWidgets where id = %d", $id);
  $res = $wpdb->query($sql);
  if ($res === 1) $sts = 1;
  else $sts = 0;
}
else if ($op == "update") {
  $newName = blenzaplus_stripRequest("name");
  $newDesc = blenzaplus_stripRequest("desc");
  $newVader = blenzaplus_stripRequest("vader");

  // shouldn't be setting the validator of connect is turned off
  // if it's the name or description we loaded as a hint, that doesn't count
  if ($newName == $blenzaplus_newHintName) {
    sendError($blenzaplus_missingName);
  }
  if ($newDesc == $blenzaplus_newHintDesc) {
    sendError($blenzaplus_missingDesc);
  }
  if ($newVader == $blenzaplus_newHintVader) {
    //sendError($blenzaplus_missingVader);
    $newVader = null;
  }

  if (($newVader != null) && !blenzaplus_isOption("connect")) sendError("Cannot set validator with connect disabled");

  $row = array
    (
     "name" => $newName,
     "description" => $newDesc,
     "validator" => $newVader,
     );
  $pred = array("id" => $id);
  $res = $wpdb->update("{$wpdb->prefix}blenzaplusWidgets", $row, $pred);
  /*
  if ($res === 1) $sts = 1;
  else $sts = 0;
  */
  $sts = 1;
}
else if ($op == "create") {
  $newName = blenzaplus_stripRequest("name");
  $newDesc = blenzaplus_stripRequest("desc");
  $newVader = blenzaplus_stripRequest("vader");

  // if it's the name or description we loaded as a hint, that doesn't count
  if ($newName == $blenzaplus_newHintName) {
    sendError($blenzaplus_missingName);
  }
  if ($newDesc == $blenzaplus_newHintDesc) {
    sendError($blenzaplus_missingDesc);
  }
  if ($newVader == $blenzaplus_newHintVader) {
    //sendError($blenzaplus_missingVader);
    $newVader = null;
  }

  if (($newVader != null) && !blenzaplus_isOption("connect")) sendError("Cannot set validator with connect disabled");

  $row = array
    (
     "name" => $newName,
     "description" => $newDesc,
     "validator" => $newVader,
     );
  $res = $wpdb->insert("{$wpdb->prefix}blenzaplusWidgets", $row);
  if ($res === 1) $sts = 1;
  else $sts = 0;
  $id = $wpdb->insert_id;
}
else sendError("Unknown operation");

// report the result back to the caller.
header("Content-type: text/xml");
echo "<?xml version=\"1.0\"?>\n";
echo "<blenzaplus>\n";
echo "<ty>";
echo $ty;
echo "</ty>\n";
echo "<op>";
echo $op;
echo "</op>\n";
echo "<id>";
echo $id;
echo "</id>\n";
echo "<status>";
echo $sts;
echo "</status>\n";
echo "</blenzaplus>\n";

function sendError($msg)
{
  header("Content-type: text/xml");
  echo "<?xml version=\"1.0\"?>\n";
  echo "<blenzaplus>\n";
  echo "<error>{$msg}</error>\n";
  echo "</blenzaplus>\n";
  die;
}
?>
